"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogsQuery = useLogsQuery;
var _react = require("react");
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function useLogsQuery({
  traceId,
  spanId,
  transactionId
}) {
  return (0, _react.useMemo)(() => {
    const queryStrings = [`(${_discoverUtils.TRACE_ID_FIELD}:"${traceId}" OR (not ${_discoverUtils.TRACE_ID_FIELD}:* AND "${traceId}"))`];
    if (transactionId) {
      queryStrings.push(`(${_discoverUtils.TRANSACTION_ID_FIELD}:"${transactionId}" OR (not ${_discoverUtils.TRANSACTION_ID_FIELD}:* AND "${transactionId}"))`);
    }
    if (spanId) {
      queryStrings.push(`(${_discoverUtils.SPAN_ID_FIELD}:"${spanId}" OR (not ${_discoverUtils.SPAN_ID_FIELD}:* AND "${spanId}"))`);
    }
    return {
      language: 'kuery',
      query: queryStrings.join(' AND ')
    };
  }, [traceId, spanId, transactionId]);
}