"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionNameLink = TransactionNameLink;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _routerUtils = require("@kbn/router-utils");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _plugin = require("../../../../plugin");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/transaction_name_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function TransactionNameLink({
  transactionName,
  serviceName,
  renderContent
}) {
  var _core$application$cap, _renderContent;
  const {
    share: {
      url: urlService
    },
    core,
    data: dataService
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const canViewApm = ((_core$application$cap = core.application.capabilities.apm) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.show) || false;
  const {
    from: timeRangeFrom,
    to: timeRangeTo
  } = dataService.query.timefilter.timefilter.getTime();
  const apmLinkToTransactionByNameLocator = urlService.locators.get(_deeplinksObservability.TRANSACTION_DETAILS_BY_NAME_LOCATOR);
  const href = serviceName && (apmLinkToTransactionByNameLocator === null || apmLinkToTransactionByNameLocator === void 0 ? void 0 : apmLinkToTransactionByNameLocator.getRedirectUrl({
    serviceName,
    transactionName,
    rangeFrom: timeRangeFrom,
    rangeTo: timeRangeTo
  }));
  const routeLinkProps = href ? (0, _routerUtils.getRouterLinkProps)({
    href,
    onClick: () => {
      apmLinkToTransactionByNameLocator === null || apmLinkToTransactionByNameLocator === void 0 ? void 0 : apmLinkToTransactionByNameLocator.navigate({
        serviceName,
        transactionName,
        rangeFrom: timeRangeFrom,
        rangeTo: timeRangeTo
      });
    }
  }) : undefined;
  const content = (_renderContent = renderContent === null || renderContent === void 0 ? void 0 : renderContent(transactionName)) !== null && _renderContent !== void 0 ? _renderContent : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, transactionName);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canViewApm && routeLinkProps ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, routeLinkProps, {
    "data-test-subj": "unifiedDocViewerObservabilityTracesTransactionNameLink",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }), content) : content);
}