"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanLinks = SpanLinks;
exports.getIncomingSpanLinksESQL = getIncomingSpanLinksESQL;
exports.getOutgoingSpanLinksESQL = getOutgoingSpanLinksESQL;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _esqlComposer = require("@kbn/esql-composer");
var _discoverUtils = require("@kbn/discover-utils");
var _apmTypes = require("@kbn/apm-types");
var _lazy_content_framework_section = require("../../../../content_framework/lazy_content_framework_section");
var _use_data_sources = require("../../hooks/use_data_sources");
var _use_get_generate_discover_link = require("../../hooks/use_get_generate_discover_link");
var _get_columns = require("./get_columns");
var _use_fetch_span_links = require("./use_fetch_span_links");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/span_links/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sorting = {
  sort: {
    field: 'duration',
    direction: 'desc'
  }
};
function SpanLinks({
  docId,
  traceId,
  processorEvent
}) {
  const {
    indexes
  } = (0, _use_data_sources.useDataSourcesContext)();
  const {
    generateDiscoverLink
  } = (0, _use_get_generate_discover_link.useGetGenerateDiscoverLink)({
    indexPattern: indexes.apm.traces
  });
  const [type, setType] = (0, _react2.useState)('incoming');
  const {
    loading,
    error,
    value
  } = (0, _use_fetch_span_links.useFetchSpanLinks)({
    docId,
    traceId,
    processorEvent
  });
  const spanLinks = type === 'incoming' ? value.incomingSpanLinks : value.outgoingSpanLinks;
  (0, _react2.useEffect)(() => {
    const hasData = value.incomingSpanLinks.length > 0 || value.outgoingSpanLinks.length > 0;
    if (hasData) {
      if (type === 'incoming' && value.incomingSpanLinks.length === 0) {
        setType('outgoing');
      } else if (type === 'outgoing' && value.outgoingSpanLinks.length === 0) {
        setType('incoming');
      }
    }
  }, [value, type]);
  const selectOptions = (0, _react2.useMemo)(() => [{
    'data-test-subj': 'unifiedDocViewerSpanLinkTypeSelect-incoming',
    value: 'incoming',
    text: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.spanLinks.combo.incomingLinks', {
      defaultMessage: 'Incoming links ({incomingLinks})',
      values: {
        incomingLinks: value.incomingSpanLinks.length
      }
    }),
    disabled: !value.incomingSpanLinks.length
  }, {
    'data-test-subj': 'unifiedDocViewerSpanLinkTypeSelect-outgoing',
    value: 'outgoing',
    text: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.spanLinks.combo.outgoingLinks', {
      defaultMessage: 'Outgoing links ({outgoingLinks})',
      values: {
        outgoingLinks: value.outgoingSpanLinks.length
      }
    }),
    disabled: !value.outgoingSpanLinks.length
  }], [value]);
  const columns = (0, _react2.useMemo)(() => (0, _get_columns.getColumns)({
    generateDiscoverLink,
    type
  }), [generateDiscoverLink, type]);
  const openInDiscoverLink = (0, _react2.useMemo)(() => {
    if (type === 'incoming') {
      return generateDiscoverLink(getIncomingSpanLinksESQL(traceId, docId));
    }
    if (spanLinks.length) {
      return generateDiscoverLink(getOutgoingSpanLinksESQL(spanLinks));
    }
  }, [docId, generateDiscoverLink, spanLinks, traceId, type]);
  if (loading || !error && value.incomingSpanLinks.length === 0 && value.outgoingSpanLinks.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react2.default.createElement(_lazy_content_framework_section.ContentFrameworkSection, {
    "data-test-subj": "unifiedDocViewerSpanLinksAccordion",
    id: "spanLinksSection",
    title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.spanLinks', {
      defaultMessage: 'Span links'
    }),
    description: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.spanLinks.description', {
      defaultMessage: 'Links to spans or transactions that are causally related'
    }),
    actions: openInDiscoverLink ? [{
      icon: 'discoverApp',
      label: _constants.OPEN_IN_DISCOVER_LABEL,
      ariaLabel: _constants.OPEN_IN_DISCOVER_LABEL_ARIAL_LABEL,
      href: openInDiscoverLink,
      dataTestSubj: 'unifiedDocViewerSpanLinksRefreshButton'
    }] : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }), error ? /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.error', {
    defaultMessage: 'An error happened when trying to fetch data. Please try again'
  })) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
                  align-items: flex-end;
                `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelect, {
    compressed: true,
    "aria-label": _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.spanLinks.select.ariaLabel', {
      defaultMessage: 'Span link type selector'
    }),
    "data-test-subj": "unifiedDocViewerSpanLinkTypeSelect",
    options: selectOptions,
    value: type,
    onChange: e => {
      setType(e.target.value);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiInMemoryTable, {
    responsiveBreakpoint: false,
    items: spanLinks,
    columns: columns,
    pagination: {
      showPerPageOptions: false,
      pageSize: 5
    },
    sorting: sorting,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  })))));
}
function getIncomingSpanLinksESQL(traceId, docId) {
  return (0, _esqlComposer.where)(`QSTR("${_discoverUtils.OTEL_LINKS_TRACE_ID}:${traceId} AND ${_discoverUtils.OTEL_LINKS_SPAN_ID}:${docId}") OR QSTR("${_discoverUtils.SPAN_LINKS_TRACE_ID}:${traceId} AND ${_apmTypes.SPAN_LINKS_SPAN_ID}:${docId}")`);
}
function getOutgoingSpanLinksESQL(spanLinks) {
  const traceIds = [];
  const spanIds = [];
  spanLinks.forEach(({
    traceId,
    spanId
  }) => {
    traceIds.push(traceId);
    spanIds.push(spanId);
  });
  return (0, _esqlComposer.where)(`${_discoverUtils.TRACE_ID_FIELD} IN (${traceIds.map(() => '?').join()}) AND ${_discoverUtils.SPAN_ID_FIELD} IN (${spanIds.map(() => '?').join()})`, [...traceIds, ...spanIds]);
}