"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _apmUiShared = require("@kbn/apm-ui-shared");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _service_name_with_icon = require("../service_name_with_icon");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/span_links/get_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getColumns = ({
  generateDiscoverLink,
  type
}) => [{
  field: 'span',
  name: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.spanLinks.table.span', {
    defaultMessage: 'Span'
  }),
  sortable: item => {
    var _item$details;
    return ((_item$details = item.details) === null || _item$details === void 0 ? void 0 : _item$details.spanName) || '';
  },
  render: (_, item) => {
    var _item$details2, _item$details3;
    const content = /*#__PURE__*/_react2.default.createElement(_eui.EuiTextTruncate, {
      "data-test-subj": `${type}-spanName-${item.spanId}`,
      text: ((_item$details2 = item.details) === null || _item$details2 === void 0 ? void 0 : _item$details2.spanName) || _constants.NOT_AVAILABLE_LABEL,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    });
    const href = generateDiscoverLink((_item$details3 = item.details) !== null && _item$details3 !== void 0 && _item$details3.transactionId ? {
      [_discoverUtils.TRANSACTION_ID_FIELD]: item.details.transactionId
    } : {
      [_discoverUtils.SPAN_ID_FIELD]: item.spanId
    });
    return /*#__PURE__*/_react2.default.createElement("span", {
      css: (0, _react.css)`
            width: 100%;
          `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }, href ? /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
      "data-test-subj": `${type}-spanNameLink-${item.spanId}`,
      href: href,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 13
      }
    }, content) : content);
  }
}, {
  field: 'duration',
  name: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.spanLinks.table.duration', {
    defaultMessage: 'Duration'
  }),
  sortable: item => {
    var _item$details4;
    return ((_item$details4 = item.details) === null || _item$details4 === void 0 ? void 0 : _item$details4.duration) || 0;
  },
  render: (_, item) => {
    var _item$details5;
    return /*#__PURE__*/_react2.default.createElement(_apmUiShared.Duration, {
      duration: ((_item$details5 = item.details) === null || _item$details5 === void 0 ? void 0 : _item$details5.duration) || 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 14
      }
    });
  }
}, {
  field: 'serviceName',
  name: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.spanLinks.table.serviceName', {
    defaultMessage: 'Service name'
  }),
  sortable: item => {
    var _item$details6;
    return ((_item$details6 = item.details) === null || _item$details6 === void 0 ? void 0 : _item$details6.serviceName) || _constants.NOT_AVAILABLE_LABEL;
  },
  render: (_, item) => {
    var _item$details7, _item$details8, _item$details9;
    const serviceName = ((_item$details7 = item.details) === null || _item$details7 === void 0 ? void 0 : _item$details7.serviceName) || _constants.NOT_AVAILABLE_LABEL;
    const content = /*#__PURE__*/_react2.default.createElement(_eui.EuiTextTruncate, {
      "data-test-subj": `${type}-serviceName-${serviceName}`,
      text: serviceName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    });
    const href = (_item$details8 = item.details) !== null && _item$details8 !== void 0 && _item$details8.serviceName ? generateDiscoverLink({
      [_discoverUtils.SERVICE_NAME_FIELD]: item.details.serviceName
    }) : undefined;
    return /*#__PURE__*/_react2.default.createElement("span", {
      css: (0, _react.css)`
            width: 100%;
          `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_service_name_with_icon.ServiceNameWithIcon, {
      agentName: (_item$details9 = item.details) === null || _item$details9 === void 0 ? void 0 : _item$details9.agentName,
      serviceName: href ? /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
        "data-test-subj": `${type}-serviceNameLink-${serviceName}`,
        href: href,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 17
        }
      }, content) : content,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }));
  }
}, {
  field: 'traceId',
  name: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerSpanOverview.spanLinks.table.traceId', {
    defaultMessage: 'Trace ID'
  }),
  sortable: item => item.traceId,
  render: (_, item) => {
    const content = /*#__PURE__*/_react2.default.createElement(_eui.EuiTextTruncate, {
      "data-test-subj": `${type}-traceId-${item.traceId}`,
      text: item.traceId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 9
      }
    });
    const href = generateDiscoverLink({
      [_discoverUtils.TRACE_ID_FIELD]: item.traceId
    });
    return /*#__PURE__*/_react2.default.createElement("span", {
      css: (0, _react.css)`
            width: 100%;
          `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 9
      }
    }, href ? /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
      "data-test-subj": `${type}-traceIdLink-${item.traceId}`,
      href: href,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 13
      }
    }, content) : content);
  }
}];
exports.getColumns = getColumns;