"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttributesTitle = getAttributesTitle;
exports.getDataStreamType = getDataStreamType;
var _i18n = require("@kbn/i18n");
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getDataStreamType(record) {
  const types = (0, _discoverUtils.getFieldValue)(record, 'data_stream.type');
  if (types !== null && types !== void 0 && types.includes('logs')) return 'logs';
  if (types !== null && types !== void 0 && types.includes('metrics')) return 'metrics';
  if (types !== null && types !== void 0 && types.includes('traces')) return 'traces';
  return undefined;
}
function getAttributesTitle(record) {
  const type = getDataStreamType(record);
  switch (type) {
    case 'logs':
      return _i18n.i18n.translate('unifiedDocViewer.docView.attributes.signalAttributesTitle.logs', {
        defaultMessage: 'Log attributes'
      });
    case 'metrics':
      return _i18n.i18n.translate('unifiedDocViewer.docView.attributes.signalAttributesTitle.metrics', {
        defaultMessage: 'Metric attributes'
      });
    case 'traces':
      return _i18n.i18n.translate('unifiedDocViewer.docView.attributes.signalAttributesTitle.traces', {
        defaultMessage: 'Span attributes'
      });
    default:
      return _i18n.i18n.translate('unifiedDocViewer.docView.attributes.signalAttributesTitle.default', {
        defaultMessage: 'Attributes'
      });
  }
}