"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentFrameworkTable = ContentFrameworkTable;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _get_formatted_fields = require("@kbn/discover-utils/src/utils/get_formatted_fields");
var _get_flattened_fields = require("@kbn/discover-utils/src/utils/get_flattened_fields");
var _react2 = require("@emotion/react");
var _useWindowSize = _interopRequireDefault(require("react-use/lib/useWindowSize"));
var _plugin = require("../../../plugin");
var _field_row = require("../../doc_viewer_table/field_row");
var _table_grid = require("../../doc_viewer_table/table_grid");
var _formatted_value = require("./components/formatted_value");
var _name_popover_content = require("./components/name_popover_content");
var _value_popover_content = require("./components/value_popover_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/content_framework/table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_INITIAL_PAGE_SIZE = 25;
function ContentFrameworkTable({
  hit,
  fieldNames,
  fieldConfigurations,
  dataView,
  columns,
  id,
  textBasedHits,
  'data-test-subj': dataTestSubj,
  filter,
  onAddColumn,
  onRemoveColumn
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    fieldsMetadata: {
      useFieldsMetadata
    },
    fieldFormats
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const {
    fieldsMetadata = {}
  } = useFieldsMetadata({
    attributes: ['short', 'type'],
    fieldNames
  });
  const {
    formattedHit,
    flattenedHit
  } = (0, _react.useMemo)(() => ({
    formattedHit: (0, _get_formatted_fields.getFormattedFields)(hit, fieldNames, {
      dataView,
      fieldFormats
    }),
    flattenedHit: (0, _get_flattened_fields.getFlattenedFields)(hit, fieldNames)
  }), [dataView, fieldFormats, hit, fieldNames]);
  const isEsqlMode = Array.isArray(textBasedHits);
  const [containerRef, setContainerRef] = (0, _react.useState)(null);
  (0, _useWindowSize.default)(); // trigger re-render on window resize to recalculate the grid container height
  const {
    width: containerWidth
  } = (0, _eui.useResizeObserver)(containerRef);
  const {
    fields,
    rows
  } = (0, _react.useMemo)(() => fieldNames.reduce((acc, fieldName) => {
    var _fieldsMetadata$field, _fieldsMetadata$field2;
    const value = flattenedHit[fieldName];
    const fieldConfiguration = fieldConfigurations === null || fieldConfigurations === void 0 ? void 0 : fieldConfigurations[fieldName];
    const fieldDescription = (fieldConfiguration === null || fieldConfiguration === void 0 ? void 0 : fieldConfiguration.description) || ((_fieldsMetadata$field = fieldsMetadata[fieldName]) === null || _fieldsMetadata$field === void 0 ? void 0 : _fieldsMetadata$field.short);
    const formattedValue = formattedHit[fieldName];
    if (!value) return acc;
    acc.fields[fieldName] = {
      name: (fieldConfiguration === null || fieldConfiguration === void 0 ? void 0 : fieldConfiguration.title) || fieldName,
      value,
      description: fieldDescription,
      type: (_fieldsMetadata$field2 = fieldsMetadata[fieldName]) === null || _fieldsMetadata$field2 === void 0 ? void 0 : _fieldsMetadata$field2.type,
      valueCellContent: ({
        truncate
      } = {
        truncate: true
      }) => {
        return fieldConfiguration !== null && fieldConfiguration !== void 0 && fieldConfiguration.formatter ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fieldConfiguration.formatter(value, formattedValue)) : /*#__PURE__*/_react.default.createElement(_formatted_value.FormattedValue, {
          value: formattedValue,
          truncate: truncate,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 17
          }
        });
      }
    };
    acc.rows.push(new _field_row.FieldRow({
      name: fieldName,
      displayNameOverride: fieldName,
      flattenedValue: value,
      hit,
      dataView,
      fieldFormats,
      isPinned: false,
      columnsMeta: {}
    }));
    return acc;
  }, {
    fields: {},
    rows: []
  }), [dataView, fieldConfigurations, fieldFormats, fieldNames, fieldsMetadata, flattenedHit, formattedHit, hit]);
  const cellValueRenderer = (0, _react.useCallback)(({
    rowIndex,
    columnId
  }) => {
    var _rows$rowIndex;
    const fieldName = (_rows$rowIndex = rows[rowIndex]) === null || _rows$rowIndex === void 0 ? void 0 : _rows$rowIndex.name;
    const fieldConfig = fields[fieldName];
    if (!fieldConfig) return null;
    if (columnId === 'name') {
      const rowDataTestSubj = `${dataTestSubj}${fieldConfig.name.replace(/ (\w)/g, (_, c) => c.toUpperCase()).replace(/^\w/, c => c.toUpperCase())}`;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        css: {
          fontWeight: euiTheme.font.weight.bold
        },
        "data-test-subj": rowDataTestSubj,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 13
        }
      }, fieldConfig.name));
    }
    return fieldConfig.valueCellContent();
  }, [rows, fields, dataTestSubj, euiTheme.font.weight.bold]);
  const cellPopoverRenderer = (0, _react.useCallback)(props => {
    var _rows$rowIndex2;
    const {
      columnId,
      cellActions,
      rowIndex
    } = props;
    const fieldName = (_rows$rowIndex2 = rows[rowIndex]) === null || _rows$rowIndex2 === void 0 ? void 0 : _rows$rowIndex2.name;
    const fieldConfig = fields[fieldName];
    if (!fieldConfig) return null;
    if (columnId === 'name') {
      return /*#__PURE__*/_react.default.createElement(_name_popover_content.NamePopoverContent, {
        fieldName: fieldName,
        fieldConfig: fieldConfig,
        cellActions: cellActions,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 11
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_value_popover_content.ValuePopoverContent, {
      fieldConfig: fieldConfig,
      cellActions: cellActions,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 14
      }
    });
  }, [rows, fields]);
  if (Object.keys(hit.flattened).length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: setContainerRef
    // EUI Override: .euiDataGrid__virtualized is necessary to prevent a blank space at the bottom of the grid due to an internal height calculation
    ,
    css: (0, _react2.css)`
        .euiDataGrid__virtualized {
          height: auto !important;
        }
        .euiDataGridRow:last-of-type .euiDataGridRowCell {
          border-bottom: none;
        }
      `,
    "data-test-subj": dataTestSubj,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_table_grid.TableGrid, {
    "data-test-subj": "ContentFrameworkTableTableGrid",
    id: id,
    containerWidth: containerWidth,
    rows: rows,
    isEsqlMode: isEsqlMode,
    filter: filter,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    columns: columns,
    initialPageSize: DEFAULT_INITIAL_PAGE_SIZE,
    customRenderCellValue: cellValueRenderer,
    customRenderCellPopover: cellPopoverRenderer,
    gridStyle: {
      stripes: false,
      rowHover: 'none',
      header: 'shade'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }));
}