"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderDrilldownManagerFooter = exports.DrilldownManagerFooter = void 0;
var _react = _interopRequireDefault(require("react"));
var _context = require("../context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DrilldownManagerFooter = ({
  children
}) => {
  const drilldowns = (0, _context.useDrilldownManager)();
  _react.default.useEffect(() => {
    drilldowns.setFooter(children);
    return () => {
      drilldowns.setFooter(null);
    };
  });
  return null;
};
exports.DrilldownManagerFooter = DrilldownManagerFooter;
const RenderDrilldownManagerFooter = () => {
  const drilldowns = (0, _context.useDrilldownManager)();
  const footer = drilldowns.useFooter();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, footer);
};
exports.RenderDrilldownManagerFooter = RenderDrilldownManagerFooter;