"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPublicDrilldownManager = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var React = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/ui_actions_enhanced/public/drilldowns/drilldown_manager/containers/drilldown_manager/create_public_drilldown_manager.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LazyDrilldownManager = /*#__PURE__*/React.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./drilldown_manager_with_provider'))).then(m => ({
  default: m.DrilldownManagerWithProvider
})));

/**
 * This HOC creates a "public" `<DrilldownManager>` component `PublicDrilldownManagerComponent`,
 * which can be exported from plugin contract for other plugins to consume.
 */
const createPublicDrilldownManager = dependencies => {
  const PublicDrilldownManager = drilldownManagerProps => {
    const filteredActionFactories = dependencies.actionFactories.filter(factory => {
      const supportedTriggers = factory.supportedTriggers();
      for (const supportedTrigger of supportedTriggers) {
        const supportsAtLeastOneTrigger = drilldownManagerProps.triggers.includes(supportedTrigger);
        if (supportsAtLeastOneTrigger) return true;
      }
      return false;
    });
    return /*#__PURE__*/React.createElement(React.Suspense, {
      fallback: null,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 7
      }
    }, /*#__PURE__*/React.createElement(LazyDrilldownManager, (0, _extends2.default)({}, dependencies, drilldownManagerProps, {
      actionFactories: filteredActionFactories,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    })));
  };
  return PublicDrilldownManager;
};
exports.createPublicDrilldownManager = createPublicDrilldownManager;