"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateDrilldownForm = void 0;
var React = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _drilldown_manager_title = require("../drilldown_manager_title");
var _context = require("../context");
var _action_factory_picker = require("../action_factory_picker");
var _drilldown_manager_footer = require("../drilldown_manager_footer");
var _drilldown_state_form = require("../drilldown_state_form");
var _button_submit = require("../../components/button_submit");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/ui_actions_enhanced/public/drilldowns/drilldown_manager/containers/create_drilldown_form/create_drilldown_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const txtCreateDrilldown = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.containers.createDrilldownForm.title', {
  defaultMessage: 'Create Drilldown',
  description: 'Drilldowns flyout title for new drilldown form.'
});
const txtCreateDrilldownButton = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.containers.createDrilldownForm.primaryButton', {
  defaultMessage: 'Create drilldown',
  description: 'Primary button on new drilldown creation form.'
});
const CreateDrilldownForm = () => {
  const isMounted = (0, _useMountedState.default)();
  const drilldowns = (0, _context.useDrilldownManager)();
  const drilldownState = drilldowns.getDrilldownState();
  const error = drilldownState.useError();
  const [disabled, setDisabled] = React.useState(false);
  const handleCreate = () => {
    setDisabled(true);
    drilldowns.createDrilldown().finally(() => {
      if (!isMounted()) return;
      setDisabled(false);
    });
  };
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_drilldown_manager_title.DrilldownManagerTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, txtCreateDrilldown), /*#__PURE__*/React.createElement(_action_factory_picker.ActionFactoryPicker, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }), !!drilldownState && /*#__PURE__*/React.createElement(_drilldown_state_form.DrilldownStateForm, {
    state: drilldownState,
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 28
    }
  }), !!drilldownState && /*#__PURE__*/React.createElement(_drilldown_manager_footer.DrilldownManagerFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/React.createElement(_button_submit.ButtonSubmit, {
    disabled: disabled || !!error,
    onClick: handleCreate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }, txtCreateDrilldownButton)));
};
exports.CreateDrilldownForm = CreateDrilldownForm;