"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEST_SUBJ_PRESENTABLE_ITEM = exports.PresentablePickerItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("./i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/ui_actions_enhanced/public/components/presentable_picker/presentable_picker_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const TEST_SUBJ_PRESENTABLE_ITEM = exports.TEST_SUBJ_PRESENTABLE_ITEM = 'actionFactoryItem';
const PresentablePickerItem = ({
  item,
  context,
  onSelect
}) => {
  var _item$isLicenseCompat;
  const isLicenseCompatible = (_item$isLicenseCompat = item.isLicenseCompatible) !== null && _item$isLicenseCompat !== void 0 ? _item$isLicenseCompat : true;
  const showTooltip = !isLicenseCompatible;
  let content = /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenuItem, {
    css: ({
      euiTheme
    }) => (0, _react2.css)({
      '.euiKeyPadMenuItem__label': {
        height: euiTheme.size.xl
      }
    }),
    label: item.getDisplayName(context),
    "data-test-subj": `${TEST_SUBJ_PRESENTABLE_ITEM}-${item.id}`,
    onClick: () => onSelect(item.id),
    disabled: !isLicenseCompatible,
    betaBadgeLabel: item.isBeta ? _i18n.txtBetaActionFactoryLabel : undefined,
    betaBadgeTooltipContent: item.isBeta ? _i18n.txtBetaActionFactoryTooltip : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, item.getIconType(context) && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: item.getIconType(context),
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 37
    }
  }));
  if (showTooltip) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.txtInsufficientLicenseLevel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 15
      }
    }, content);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: item.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, content);
};
exports.PresentablePickerItem = PresentablePickerItem;