"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadAlertRuleFlyoutContent = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _common = require("@kbn/expressions-plugin/common");
var _rule_flyout_component = require("./rule_flyout_component");
var _build_additional_query = require("./build_additional_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadAlertRuleFlyoutContent = async ({
  embeddable,
  data,
  closeFlyout,
  startDependencies,
  ruleTypeRegistry,
  actionTypeRegistry
}) => {
  var _embeddable$dataViews, _embeddable$serialize, _state$datasourceStat, _state$datasourceStat2;
  const embeddableData = data !== null && data !== void 0 && data.query ? data : data ? {
    ...data,
    ...(0, _lodash.pick)(getDataFromEmbeddable(embeddable), ['query', 'dataView', 'usesPlaceholderValues'])
  } : getDataFromEmbeddable(embeddable);
  const {
    query
  } = embeddableData;
  const datatable = getDataTableFromEmbeddable(embeddable);
  const dataView = query ? undefined : (_embeddable$dataViews = embeddable.dataViews$.getValue()) === null || _embeddable$dataViews === void 0 ? void 0 : _embeddable$dataViews.find(view => {
    var _datatable$meta;
    return view.id === (datatable === null || datatable === void 0 ? void 0 : (_datatable$meta = datatable.meta) === null || _datatable$meta === void 0 ? void 0 : _datatable$meta.source);
  });
  const {
    state
  } = (_embeddable$serialize = embeddable.serializeState().rawState.attributes) !== null && _embeddable$serialize !== void 0 ? _embeddable$serialize : {};
  const layers = state === null || state === void 0 ? void 0 : (_state$datasourceStat = state.datasourceStates) === null || _state$datasourceStat === void 0 ? void 0 : (_state$datasourceStat2 = _state$datasourceStat.textBased) === null || _state$datasourceStat2 === void 0 ? void 0 : _state$datasourceStat2.layers;
  const [firstLayer] = Object.values(layers !== null && layers !== void 0 ? layers : {});
  const {
    timeField = 'timestamp'
  } = firstLayer !== null && firstLayer !== void 0 ? firstLayer : {
    timeField: dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName
  };
  const additionalQuery = (0, _build_additional_query.buildAdditionalQuery)(embeddableData);
  let initialValues;
  if (query) {
    const queryHeader = _i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.queryHeaderComment', {
      defaultMessage: 'Original ES|QL query derived from the visualization:'
    });
    initialValues = {
      params: {
        searchType: 'esqlQuery',
        esqlQuery: {
          esql: `// ${queryHeader}\n${query}\n${additionalQuery}`
        },
        timeField
      }
    };
  } else {
    const missingQueryComment = `// ${_i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.missingQueryComment', {
      defaultMessage: 'Unable to generate an ES|QL query from the visualization.'
    })}`;
    let esql = missingQueryComment;
    if (dataView) {
      const [index] = dataView.matchedIndices;
      const esqlFromDataviewComment = `// ${_i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.esqlFromDataviewComment', {
        defaultMessage: 'Unable to automatically generate an ES|QL query that produces the same data as this visualization. You may be able to reproduce it manually using this data source:'
      })}`;
      const dataViewQuery = `FROM ${index}`;
      esql = `${esqlFromDataviewComment}\n${dataViewQuery}\n${additionalQuery}`;
    }
    initialValues = {
      params: {
        searchType: 'esqlQuery',
        esqlQuery: {
          esql
        },
        timeField
      }
    };
  }
  const ruleFlyoutComponent = await (0, _rule_flyout_component.getRuleFlyoutComponent)(startDependencies, ruleTypeRegistry, actionTypeRegistry, embeddable.parentApi, closeFlyout, {
    ...initialValues,
    tags: [],
    name: _i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.embeddable.alertRuleTitle.defaultName', {
      defaultMessage: 'Elasticsearch query rule from visualization'
    })
  });
  return ruleFlyoutComponent;
};
exports.loadAlertRuleFlyoutContent = loadAlertRuleFlyoutContent;
const getDataTableFromEmbeddable = embeddable => {
  var _embeddable$getInspec;
  return Object.values((_embeddable$getInspec = embeddable.getInspectorAdapters().tables.tables) !== null && _embeddable$getInspec !== void 0 ? _embeddable$getInspec : {})[0];
};
const getDataFromEmbeddable = embeddable => {
  const queryValue = embeddable.query$.getValue();
  const query = queryValue && 'esql' in queryValue ? queryValue.esql : null;
  const datatable = getDataTableFromEmbeddable(embeddable);
  const thresholdValues = datatable ? datatable.columns.filter(col => col.meta.dimensionType === _common.DimensionType.Y_AXIS).map(({
    meta
  }) => {
    var _meta$sourceParams;
    const {
      sourceField = missingYFieldPlaceholder
    } = (_meta$sourceParams = meta.sourceParams) !== null && _meta$sourceParams !== void 0 ? _meta$sourceParams : {};
    return {
      values: {
        [String(sourceField)]: _i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.thresholdPlaceholder', {
          defaultMessage: '[THRESHOLD]'
        })
      },
      yField: String(sourceField)
    };
  }) : [];
  const xColumns = datatable === null || datatable === void 0 ? void 0 : datatable.columns.filter(col => col.meta.dimensionType === _common.DimensionType.X_AXIS);
  const isTimeViz = xColumns === null || xColumns === void 0 ? void 0 : xColumns.some(({
    meta
  }) => meta.type === 'date');
  const xValues = isTimeViz || !xColumns ? {} : xColumns.reduce((result, {
    meta
  }) => {
    var _meta$sourceParams2;
    const {
      sourceField = missingXFieldPlaceholder
    } = (_meta$sourceParams2 = meta.sourceParams) !== null && _meta$sourceParams2 !== void 0 ? _meta$sourceParams2 : {};
    return {
      ...result,
      [String(sourceField)]: [_i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.splitValuePlaceholder', {
        defaultMessage: '[VALUE]'
      })]
    };
  }, {});
  return {
    query,
    xValues,
    thresholdValues,
    usesPlaceholderValues: true
  };
};
const missingYFieldPlaceholder = _i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.yAxisPlaceholder', {
  defaultMessage: '[Y AXIS]'
});
const missingXFieldPlaceholder = _i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.xAxisPlaceholder', {
  defaultMessage: '[X AXIS]'
});