"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesListTableStatusCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _rule_status_helpers = require("../../../../common/lib/rule_status_helpers");
var _translations = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rules_list_table_status_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RulesListTableStatusCell = props => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    rule,
    onManageLicenseClick
  } = props;
  const {
    lastRun
  } = rule;
  const isLicenseError = (0, _rule_status_helpers.getIsLicenseError)(rule);
  const healthColor = (0, _rule_status_helpers.getRuleHealthColor)(rule, euiTheme);
  const statusMessage = (0, _rule_status_helpers.getRuleStatusMessage)({
    rule,
    licenseErrorText: _translations.ALERT_STATUS_LICENSE_ERROR,
    lastOutcomeTranslations: _translations.rulesLastRunOutcomeTranslationMapping,
    executionStatusTranslations: _translations.rulesStatusesTranslationsMapping
  });
  const tooltipMessage = (lastRun === null || lastRun === void 0 ? void 0 : lastRun.outcome) === 'failed' ? `Error: ${lastRun === null || lastRun === void 0 ? void 0 : lastRun.outcomeMsg}` : null;
  if (!statusMessage) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
      titleSize: "xs",
      title: "--",
      description: "",
      isLoading: !(lastRun !== null && lastRun !== void 0 && lastRun.outcome) && !rule.nextRun,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 7
      }
    });
  }
  const health = /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    "data-test-subj": `ruleStatus-${(lastRun === null || lastRun === void 0 ? void 0 : lastRun.outcome) || 'pending'}`,
    color: healthColor || 'default',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, statusMessage);
  const healthWithTooltip = tooltipMessage ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "ruleStatus-error-tooltip",
    position: "top",
    content: tooltipMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, health) : health;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, healthWithTooltip), isLicenseError && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    "data-test-subj": "ruleStatus-error-license-fix",
    onClick: () => onManageLicenseClick(rule),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.fixLicenseLink",
    defaultMessage: "Fix",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }))));
};
exports.RulesListTableStatusCell = RulesListTableStatusCell;