"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleRouteWithApi = exports.RuleRoute = void 0;
exports.getRuleSummary = getRuleSummary;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
var _rule = require("./rule");
var _kibana = require("../../../../common/lib/kibana");
var _center_justified_spinner = require("../../../components/center_justified_spinner");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rule_details/components/rule_route.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleRoute = ({
  rule,
  ruleType,
  readOnly,
  requestRefresh,
  loadRuleSummary: loadRuleSummary,
  refreshToken
}) => {
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [ruleSummary, setRuleSummary] = (0, _react.useState)(null);
  const [numberOfExecutions, setNumberOfExecutions] = (0, _react.useState)(60);
  const [isLoadingChart, setIsLoadingChart] = (0, _react.useState)(true);
  const ruleID = (0, _react.useRef)(null);
  const refreshTokenRef = (0, _react.useRef)(refreshToken);
  const getRuleSummaryWithLoadingState = (0, _react.useCallback)(async (executions = numberOfExecutions) => {
    setIsLoadingChart(true);
    await getRuleSummary(ruleID.current, loadRuleSummary, setRuleSummary, toasts, executions);
    setIsLoadingChart(false);
  }, [setIsLoadingChart, ruleID, loadRuleSummary, setRuleSummary, toasts, numberOfExecutions]);
  (0, _react.useEffect)(() => {
    if (ruleID.current !== rule.id) {
      ruleID.current = rule.id;
      getRuleSummaryWithLoadingState();
    }
  }, [rule, ruleID, getRuleSummaryWithLoadingState]);
  (0, _react.useEffect)(() => {
    if (refreshTokenRef.current !== refreshToken) {
      refreshTokenRef.current = refreshToken;
      getRuleSummaryWithLoadingState();
    }
  }, [refreshToken, refreshTokenRef, getRuleSummaryWithLoadingState]);
  const onChangeDuration = (0, _react.useCallback)(executions => {
    setNumberOfExecutions(executions);
    getRuleSummaryWithLoadingState(executions);
  }, [getRuleSummaryWithLoadingState]);
  return ruleSummary ? /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 25
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_rule.RuleWithApi, {
    requestRefresh: requestRefresh,
    refreshToken: refreshToken,
    rule: rule,
    ruleType: ruleType,
    readOnly: readOnly,
    ruleSummary: ruleSummary,
    numberOfExecutions: numberOfExecutions,
    isLoadingChart: isLoadingChart,
    onChangeDuration: onChangeDuration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  });
};
exports.RuleRoute = RuleRoute;
async function getRuleSummary(ruleId, loadRuleSummary, setRuleSummary, toasts, executionDuration) {
  try {
    const loadedSummary = await loadRuleSummary(ruleId, executionDuration);
    setRuleSummary(loadedSummary);
  } catch (e) {
    toasts.addDanger({
      title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.unableToLoadRulesMessage', {
        defaultMessage: 'Unable to load rules: {message}',
        values: {
          message: e.message
        }
      })
    });
  }
}
const RuleRouteWithApi = exports.RuleRouteWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(RuleRoute);