"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActionsPopover = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rule_details/components/rule_actions_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleActionsPopover = ({
  rule,
  onDelete,
  onApiKeyUpdate,
  onEnableDisable,
  onRunRule,
  isInternallyManaged
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const ruleActionsPopover = (0, _react2.css)`
    .ruleActionsPopover__deleteButton {
      color: ${euiTheme.colors.textDanger};
    }
  `;
  const getDisableEnablePanelItem = testId => ({
    'data-test-subj': testId,
    onClick: async () => {
      setIsPopoverOpen(false);
      onEnableDisable(!rule.enabled);
    },
    name: !rule.enabled ? _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.enableRuleButtonLabel', {
      defaultMessage: 'Enable'
    }) : _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.disableRuleButtonLabel', {
      defaultMessage: 'Disable'
    })
  });
  const getUpdateApiKeyPanelItem = testId => {
    return {
      'data-test-subj': testId,
      onClick: () => {
        setIsPopoverOpen(false);
        onApiKeyUpdate(rule.id);
      },
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.updateAPIKeyButtonLabel', {
        defaultMessage: 'Update API key'
      })
    };
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      disabled: false,
      "data-test-subj": "ruleActionsButton",
      "data-testid": "ruleActionsButton",
      iconType: "boxesHorizontal",
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.popoverButtonTitle', {
        defaultMessage: 'Actions'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    ownFocus: true,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: 0,
      items: isInternallyManaged ? [getDisableEnablePanelItem('disableButtonInternallyManaged'), getUpdateApiKeyPanelItem('updateAPIKeyButtonInternallyManaged')] : [getDisableEnablePanelItem('disableButton'), getUpdateApiKeyPanelItem('updateAPIKeyButton'), {
        'data-test-subj': 'runRuleButton',
        onClick: () => {
          setIsPopoverOpen(false);
          onRunRule(rule.id);
        },
        name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.runRuleButtonLabel', {
          defaultMessage: 'Run rule'
        })
      }, {
        className: 'ruleActionsPopover__deleteButton',
        'data-test-subj': 'deleteRuleButton',
        onClick: () => {
          setIsPopoverOpen(false);
          onDelete(rule.id);
        },
        name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.deleteRuleButtonLabel', {
          defaultMessage: 'Delete rule'
        })
      }]
    }],
    className: "ruleActionsPopover",
    "data-test-subj": "ruleActionsPopover",
    "data-testid": "ruleActionsPopover",
    css: ruleActionsPopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }));
};
exports.RuleActionsPopover = RuleActionsPopover;