"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertMutedSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rule_details/components/alert_muted_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertMutedSwitch = ({
  alert,
  onMuteAction,
  disabled
}) => {
  const [isMuted, setIsMuted] = (0, _react.useState)(alert === null || alert === void 0 ? void 0 : alert.isMuted);
  const [isUpdating, setIsUpdating] = (0, _react.useState)(false);
  return isUpdating ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "mute",
    disabled: disabled,
    compressed: true,
    checked: isMuted,
    onChange: async () => {
      setIsUpdating(true);
      await onMuteAction(alert);
      setIsMuted(!isMuted);
      setIsUpdating(false);
    },
    "data-test-subj": `muteAlertButton_${alert.alert}`,
    showLabel: false,
    label: "mute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  });
};
exports.AlertMutedSwitch = AlertMutedSwitch;