"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValidConnectors = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getValidConnectors = (connectors, actionItem, actionTypesIndex, allowGroupConnector = []) => {
  const actionType = actionTypesIndex[actionItem.actionTypeId];
  return connectors.filter(connector => (allowGroupConnector.includes(connector.actionTypeId) && actionTypesIndex[connector.actionTypeId].enabledInConfig || connector.actionTypeId === actionItem.actionTypeId) && (
  // include only enabled by config connectors or preconfigured
  (actionType === null || actionType === void 0 ? void 0 : actionType.enabledInConfig) || connector.isPreconfigured));
};
exports.getValidConnectors = getValidConnectors;