"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UntrackAlertsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/common/components/untrack_alerts_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UNTRACK_ORPHANED_ALERTS_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.untrackAlertsModal.title', {
  defaultMessage: 'Disable rule'
});
const UNTRACK_ORPHANED_ALERTS_CONFIRM_BUTTON_TEXT = _i18n.i18n.translate('xpack.triggersActionsUI.sections.untrackAlertsModal.confirmButtonText', {
  defaultMessage: 'Disable'
});
const UNTRACK_ORPHANED_ALERTS_CANCEL_BUTTON_TEXT = _i18n.i18n.translate('xpack.triggersActionsUI.sections.untrackAlertsModal.cancelButtonText', {
  defaultMessage: 'Cancel'
});
const UNTRACK_ORPHANED_ALERTS_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.sections.untrackAlertsModal.toggleLabel', {
  defaultMessage: 'Change alert statuses from active to untracked'
});
const UntrackAlertsModal = props => {
  const {
    onCancel,
    onConfirm
  } = props;
  const [isUntrack, setIsUntrack] = (0, _react.useState)(false);
  const onChange = (0, _react.useCallback)(e => {
    setIsUntrack(e.target.checked);
  }, []);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "untrackAlertsModal",
    title: UNTRACK_ORPHANED_ALERTS_TITLE,
    onCancel: onCancel,
    onConfirm: () => onConfirm(isUntrack),
    confirmButtonText: UNTRACK_ORPHANED_ALERTS_CONFIRM_BUTTON_TEXT,
    cancelButtonText: UNTRACK_ORPHANED_ALERTS_CANCEL_BUTTON_TEXT,
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "untrackAlertsModalSwitch",
    label: UNTRACK_ORPHANED_ALERTS_LABEL,
    checked: isUntrack,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }));
};
exports.UntrackAlertsModal = UntrackAlertsModal;