"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventLogListStatusFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _get_experimental_features = require("../../../../../common/get_experimental_features");
var _event_log_list_status = require("./event_log_list_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/common/components/event_log/event_log_list_status_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const statusFilters = ['success', 'failure', 'warning', 'unknown'];
const EventLogListStatusFilter = props => {
  const {
    selectedOptions = [],
    onChange = () => {}
  } = props;
  const isRuleUsingExecutionStatus = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleUseExecutionStatus');
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onFilterItemClick = (0, _react.useCallback)(newOption => () => {
    if (selectedOptions.includes(newOption)) {
      onChange(selectedOptions.filter(option => option !== newOption));
      return;
    }
    onChange([...selectedOptions, newOption]);
  }, [selectedOptions, onChange]);
  const onClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(prevIsOpen => !prevIsOpen);
  }, [setIsPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    "data-test-subj": "eventLogStatusFilter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": "eventLogStatusFilterButton",
      iconType: "arrowDown",
      isSelected: isPopoverOpen,
      hasActiveFilters: selectedOptions.length > 0,
      numActiveFilters: selectedOptions.length,
      numFilters: selectedOptions.length,
      onClick: onClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.eventLogStatusFilterLabel",
      defaultMessage: "Response",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, statusFilters.map(status => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      key: status,
      "data-test-subj": `eventLogStatusFilter-${status}`,
      onClick: onFilterItemClick(status),
      checked: selectedOptions.includes(status) ? 'on' : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_event_log_list_status.EventLogListStatus, {
      status: status,
      useExecutionStatus: isRuleUsingExecutionStatus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 17
      }
    }));
  }))));
};
exports.EventLogListStatusFilter = EventLogListStatusFilter;