"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventLogListStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../rules_list/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/common/components/event_log/event_log_list_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const statusContainerStyles = {
  display: 'flex',
  alignItems: 'center',
  textTransform: 'capitalize'
};
const iconStyles = {
  marginRight: '8px'
};
const STATUS_TO_OUTCOME = {
  success: _translations.RULE_LAST_RUN_OUTCOME_SUCCEEDED,
  failure: _translations.RULE_LAST_RUN_OUTCOME_FAILED,
  warning: _translations.RULE_LAST_RUN_OUTCOME_WARNING,
  unknown: _translations.ALERT_STATUS_UNKNOWN
};
const EventLogListStatus = props => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    status,
    useExecutionStatus = true
  } = props;
  const STATUS_TO_COLOR = {
    success: euiTheme.colors.success,
    failure: euiTheme.colors.danger,
    unknown: euiTheme.colors.mediumShade,
    warning: euiTheme.colors.warning
  };
  const color = STATUS_TO_COLOR[status] || 'gray';
  const statusString = (0, _react.useMemo)(() => {
    if (useExecutionStatus) {
      return status;
    }
    return STATUS_TO_OUTCOME[status].toLocaleLowerCase();
  }, [useExecutionStatus, status]);
  return /*#__PURE__*/_react.default.createElement("span", {
    style: statusContainerStyles,
    "data-test-subj": "eventLogListStatus",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "dot",
    color: color,
    style: iconStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }), statusString);
};
exports.EventLogListStatus = EventLogListStatus;