"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.EditConnectorFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/actions-plugin/common");
var _Option = require("fp-ts/Option");
var _read_only = require("./read_only");
var _types = require("../../../../types");
var _connector_form = require("../connector_form");
var _use_edit_connector = require("../../../hooks/use_edit_connector");
var _kibana = require("../../../../common/lib/kibana");
var _capabilities = require("../../../lib/capabilities");
var _test_connector_form = require("../test_connector_form");
var _connector_rules_list = require("../connector_rules_list");
var _use_execute_connector = require("../../../hooks/use_execute_connector");
var _header = require("./header");
var _footer = require("./footer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/action_connector_form/edit_connector_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getConnectorWithoutSecrets = connector => {
  var _connector$isMissingS;
  return {
    ...connector,
    isMissingSecrets: (_connector$isMissingS = connector.isMissingSecrets) !== null && _connector$isMissingS !== void 0 ? _connector$isMissingS : false,
    secrets: {}
  };
};
const EditConnectorFlyoutComponent = ({
  actionTypeRegistry,
  connector,
  onClose,
  tab = _types.EditConnectorTabs.Configuration,
  onConnectorUpdated
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    docLinks,
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const isMounted = (0, _react.useRef)(false);
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const {
    isLoading: isUpdatingConnector,
    updateConnector
  } = (0, _use_edit_connector.useUpdateConnector)();
  const {
    isLoading: isExecutingConnector,
    executeConnector
  } = (0, _use_execute_connector.useExecuteConnector)();
  const [showFormErrors, setShowFormErrors] = (0, _react.useState)(false);
  const [preSubmitValidationErrorMessage, setPreSubmitValidationErrorMessage] = (0, _react.useState)(null);
  const [formState, setFormState] = (0, _react.useState)({
    isSubmitted: false,
    isSubmitting: false,
    isValid: undefined,
    submit: async () => ({
      isValid: false,
      data: {}
    }),
    preSubmitValidator: null
  });
  const [selectedTab, setTab] = (0, _react.useState)(tab);
  /**
   * Test connector
   */

  const [testExecutionActionParams, setTestExecutionActionParams] = (0, _react.useState)({});
  const [testExecutionResult, setTestExecutionResult] = (0, _react.useState)(_Option.none);
  const handleSetTab = (0, _react.useCallback)(nextPage => {
    if (nextPage === _types.EditConnectorTabs.Configuration && testExecutionResult !== _Option.none) {
      setTestExecutionResult(_Option.none);
    }
    setShowFormErrors(false);
    setTab(nextPage);
  }, [testExecutionResult, setTestExecutionResult]);
  const [isFormModified, setIsFormModified] = (0, _react.useState)(false);
  const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(false);
  const [isEdit, setIsEdit] = (0, _react.useState)(true);
  const [isSaved, setIsSaved] = (0, _react.useState)(false);
  const {
    preSubmitValidator,
    submit,
    isValid: isFormValid,
    isSubmitting
  } = formState;
  const hasErrors = isFormValid === false;
  const isSaving = isUpdatingConnector || isSubmitting || isExecutingConnector;
  const actionTypeModel = actionTypeRegistry.get(connector.actionTypeId);
  const showButtons = canSave && actionTypeModel && !connector.isPreconfigured;
  const onExecutionAction = (0, _react.useCallback)(async () => {
    try {
      const res = await executeConnector({
        connectorId: connector.id,
        params: testExecutionActionParams
      });
      setTestExecutionResult((0, _Option.some)(res));
    } catch (error) {
      const result = (0, _common.isActionTypeExecutorResult)(error) ? error : {
        actionId: connector.id,
        status: 'error',
        message: error.message
      };
      setTestExecutionResult((0, _Option.some)(result));
    }
  }, [connector.id, executeConnector, testExecutionActionParams]);
  const onFormModifiedChange = (0, _react.useCallback)(formModified => {
    if (formModified) {
      setIsSaved(false);
    }
    setIsFormModified(formModified);
    setTestExecutionResult(_Option.none);
  }, [setIsFormModified]);
  const closeFlyout = (0, _react.useCallback)(() => {
    if (isFormModified) {
      setShowConfirmModal(true);
      return;
    }
    onClose();
  }, [onClose, isFormModified, setShowConfirmModal]);
  const onClickSave = (0, _react.useCallback)(async () => {
    setPreSubmitValidationErrorMessage(null);
    setShowFormErrors(false);
    const {
      isValid,
      data
    } = await submit();
    if (!isMounted.current) {
      // User has closed the flyout meanwhile submitting the form
      return;
    }
    if (isValid) {
      if (preSubmitValidator) {
        const validatorRes = await preSubmitValidator();
        if (validatorRes) {
          setPreSubmitValidationErrorMessage(validatorRes.message);
          return;
        }
      }

      /**
       * At this point the form is valid
       * and there are no pre submit error messages.
       */
      const {
        name,
        config,
        secrets
      } = data;
      const validConnector = {
        id: connector.id,
        name: name !== null && name !== void 0 ? name : '',
        config: config !== null && config !== void 0 ? config : {},
        secrets: secrets !== null && secrets !== void 0 ? secrets : {}
      };
      const updatedConnector = await updateConnector(validConnector);
      if (updatedConnector) {
        /**
         * ConnectorFormSchema has been saved.
         * Set the from to clean state.
         */
        onFormModifiedChange(false);
        if (onConnectorUpdated) {
          onConnectorUpdated(updatedConnector);
        }
        setIsSaved(true);
        setIsEdit(false);
        setIsEdit(true);
      }
      return updatedConnector;
    } else {
      setShowFormErrors(true);
    }
  }, [onConnectorUpdated, submit, preSubmitValidator, connector.id, updateConnector, onFormModifiedChange]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  const renderConfigurationTab = (0, _react.useCallback)(() => {
    if (!connector.isPreconfigured && !connector.isSystemAction) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEdit && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showFormErrors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        size: "s",
        color: "danger",
        iconType: "warning",
        "data-test-subj": "connector-form-header-error-label",
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.editConnectorForm.headerFormLabel', {
          defaultMessage: 'There are errors in the form'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 242,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 254,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_connector_form.ConnectorForm, {
        actionTypeModel: actionTypeModel,
        connector: getConnectorWithoutSecrets(connector),
        isEdit: isEdit,
        onChange: setFormState,
        onFormModifiedChange: onFormModifiedChange,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 257,
          columnNumber: 15
        }
      }), !!preSubmitValidationErrorMessage && /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 264,
          columnNumber: 53
        }
      }, preSubmitValidationErrorMessage), showButtons && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        iconType: isSaved ? 'check' : undefined,
        color: "primary",
        "data-test-subj": "edit-connector-flyout-save-btn",
        isLoading: isSaving,
        onClick: onClickSave,
        disabled: !isFormModified || hasErrors || isSaving,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 17
        }
      }, isSaved ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.editConnectorForm.saveButtonSavedLabel",
        defaultMessage: "Changes Saved",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 276,
          columnNumber: 21
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.editConnectorForm.saveButtonLabel",
        defaultMessage: "Save",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 281,
          columnNumber: 21
        }
      }))));
    }
    return /*#__PURE__*/_react.default.createElement(_read_only.ReadOnlyConnectorMessage, {
      href: docLinks.links.alerting.preconfiguredConnectors,
      extraComponent: actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.actionReadOnlyExtraComponent,
      connectorId: connector.id,
      connectorName: connector.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 295,
        columnNumber: 7
      }
    });
  }, [connector, docLinks.links.alerting.preconfiguredConnectors, actionTypeModel, isEdit, showFormErrors, onFormModifiedChange, preSubmitValidationErrorMessage, showButtons, isSaved, isSaving, onClickSave, isFormModified, hasErrors]);
  const renderTestTab = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_test_connector_form.TestConnectorForm, {
      connector: connector,
      executeEnabled: !isFormModified,
      actionParams: testExecutionActionParams,
      setActionParams: setTestExecutionActionParams,
      onExecutionAction: onExecutionAction,
      isExecutingAction: isExecutingConnector,
      executionResult: testExecutionResult,
      actionTypeRegistry: actionTypeRegistry,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 7
      }
    });
  }, [connector, actionTypeRegistry, isExecutingConnector, isFormModified, testExecutionActionParams, testExecutionResult, onExecutionAction]);
  const renderConnectorRulesList = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_connector_rules_list.ConnectorRulesList, {
      connector: connector,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 342,
        columnNumber: 12
      }
    });
  }, [connector]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    "aria-labelledby": "flyoutActionEditTitle",
    size: "m",
    "data-test-subj": "edit-connector-flyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header.FlyoutHeader, {
    isPreconfigured: connector.isPreconfigured,
    connectorName: connector.name,
    connectorTypeDesc: (actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.selectMessagePreconfigured) || (actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.selectMessage),
    setTab: handleSetTab,
    selectedTab: selectedTab,
    icon: actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.iconClass,
    isExperimental: actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.isExperimental,
    subFeature: actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.subFeature,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 9
    }
  }, selectedTab === _types.EditConnectorTabs.Configuration && renderConfigurationTab(), selectedTab === _types.EditConnectorTabs.Test && renderTestTab(), selectedTab === _types.EditConnectorTabs.Rules && renderConnectorRulesList()), /*#__PURE__*/_react.default.createElement(_footer.FlyoutFooter, {
    onClose: closeFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 9
    }
  })), showConfirmModal && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    titleProps: {
      id: confirmModalTitleId
    },
    buttonColor: "danger",
    "data-test-subj": "closeConnectorEditConfirm",
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.confirmConnectorEditClose.title', {
      defaultMessage: 'Discard unsaved changes to connector?'
    }),
    onCancel: () => {
      setShowConfirmModal(false);
    },
    onConfirm: onClose,
    cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.confirmConnectorEditClose.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.confirmConnectorEditClose.discardButtonLabel', {
      defaultMessage: 'Discard Changes'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.confirmConnectorEditClose.confirmConnectorCloseMessage",
    defaultMessage: "You can't recover unsaved changes.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 11
    }
  })));
};
const EditConnectorFlyout = exports.default = exports.EditConnectorFlyout = /*#__PURE__*/(0, _react.memo)(EditConnectorFlyoutComponent);

// eslint-disable-next-line import/no-default-export