"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.muteRule = muteRule;
exports.muteRules = muteRules;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function muteRule({
  id,
  http
}) {
  await http.post(`${_constants.BASE_ALERTING_API_PATH}/rule/${encodeURIComponent(id)}/_mute_all`);
}
async function muteRules({
  ids,
  http
}) {
  await Promise.all(ids.map(id => muteRule({
    http,
    id
  })));
}