"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormattedDuration = getFormattedDuration;
exports.getFormattedMilliseconds = getFormattedMilliseconds;
exports.getFormattedSuccessRatio = getFormattedSuccessRatio;
var _moment = _interopRequireDefault(require("moment"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFormattedSuccessRatio(successRatio) {
  const formatted = (0, _numeral.default)(successRatio * 100).format('0,0');
  return `${formatted}%`;
}
function getFormattedDuration(value) {
  if (!value) {
    return '00:00';
  }
  const duration = _moment.default.duration(value);
  let minutes = Math.floor(duration.asMinutes());
  let seconds = duration.seconds();
  const ms = duration.milliseconds();
  if (ms >= 500) {
    seconds += 1;
    if (seconds === 60) {
      seconds = 0;
      minutes += 1;
    }
  }
  return `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
}
function getFormattedMilliseconds(value) {
  const formatted = (0, _numeral.default)(value).format('0,0');
  return `${formatted} ms`;
}