"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadGlobalConnectorExecutionLogAggregations = void 0;
var _common = require("@kbn/actions-plugin/common");
var _get_filter = require("../rule_api/get_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/naming-convention */

const getRenamedLog = data => {
  const {
    duration_ms,
    schedule_delay_ms,
    ...rest
  } = data;
  return {
    execution_duration: data.duration_ms,
    schedule_delay: data.schedule_delay_ms,
    ...rest
  };
};
const rewriteBodyRes = ({
  data,
  ...rest
}) => ({
  data: data.map(log => getRenamedLog(log)),
  ...rest
});
const loadGlobalConnectorExecutionLogAggregations = async ({
  http,
  dateStart,
  dateEnd,
  outcomeFilter,
  message,
  perPage = 10,
  page = 0,
  sort = [],
  namespaces
}) => {
  const sortField = sort;
  const filter = (0, _get_filter.getFilter)({
    outcomeFilter,
    message
  });
  const result = await http.post(`${_common.INTERNAL_BASE_ACTION_API_PATH}/_global_connector_execution_logs`, {
    body: JSON.stringify({
      date_start: dateStart,
      date_end: dateEnd,
      filter: filter.length ? filter.join(' and ') : undefined,
      per_page: perPage,
      // Need to add the + 1 for pages because APIs are 1 indexed,
      // whereas data grid sorts are 0 indexed.
      page: page + 1,
      sort: sortField.length ? JSON.stringify(sortField) : undefined,
      namespaces: namespaces ? JSON.stringify(namespaces) : undefined
    })
  });
  return rewriteBodyRes(result);
};
exports.loadGlobalConnectorExecutionLogAggregations = loadGlobalConnectorExecutionLogAggregations;