"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSubAction = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = require("react");
var _kibana = require("../../common/lib/kibana");
var _action_connector_api = require("../lib/action_connector_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var SubActionsActionsList = /*#__PURE__*/function (SubActionsActionsList) {
  SubActionsActionsList[SubActionsActionsList["START"] = 0] = "START";
  SubActionsActionsList[SubActionsActionsList["STOP"] = 1] = "STOP";
  SubActionsActionsList[SubActionsActionsList["SUCCESS"] = 2] = "SUCCESS";
  SubActionsActionsList[SubActionsActionsList["ERROR"] = 3] = "ERROR";
  return SubActionsActionsList;
}(SubActionsActionsList || {});
const dataFetchReducer = (state, action) => {
  switch (action.type) {
    case SubActionsActionsList.START:
      return {
        ...state,
        isLoading: true,
        error: null
      };
    case SubActionsActionsList.STOP:
      return {
        ...state,
        isLoading: false,
        error: null
      };
    case SubActionsActionsList.SUCCESS:
      return {
        ...state,
        response: action.payload,
        isLoading: false,
        error: null
      };
    case SubActionsActionsList.ERROR:
      return {
        ...state,
        error: action.payload,
        isLoading: false
      };
    default:
      return state;
  }
};
const useMemoParams = subActionsParams => {
  const paramsRef = (0, _react.useRef)(subActionsParams);
  if (!(0, _fastDeepEqual.default)(paramsRef.current, subActionsParams)) {
    paramsRef.current = subActionsParams;
  }
  return paramsRef.current;
};
const useSubAction = ({
  connectorId,
  subAction,
  subActionParams,
  disabled = false
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const [{
    isLoading,
    response,
    error
  }, dispatch] = (0, _react.useReducer)(dataFetchReducer, {
    isLoading: false,
    response: undefined,
    error: null
  });
  const memoParams = useMemoParams(subActionParams);
  (0, _react.useEffect)(() => {
    if (disabled || !connectorId || !subAction) {
      dispatch({
        type: SubActionsActionsList.STOP
      });
      return;
    }
    const abortCtrl = new AbortController();
    let isActive = true;
    const executeSubAction = async () => {
      try {
        dispatch({
          type: SubActionsActionsList.START
        });
        const res = await (0, _action_connector_api.executeAction)({
          id: connectorId,
          params: {
            subAction,
            subActionParams: memoParams
          },
          http,
          signal: abortCtrl.signal
        });
        if (isActive) {
          if (res.status && res.status === 'ok') {
            dispatch({
              type: SubActionsActionsList.SUCCESS,
              payload: res.data
            });
          } else {
            dispatch({
              type: SubActionsActionsList.ERROR,
              payload: new Error(`${res.message}: ${res.serviceMessage}`)
            });
          }
        }
        return res.data;
      } catch (err) {
        if (isActive) {
          dispatch({
            type: SubActionsActionsList.ERROR,
            payload: err
          });
        }
      }
    };
    executeSubAction();
    return () => {
      isActive = false;
      abortCtrl.abort();
    };
  }, [memoParams, disabled, connectorId, subAction, http]);
  return {
    isLoading,
    response,
    error
  };
};
exports.useSubAction = useSubAction;