"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesSettingsFlyout = exports.RulesSettingsErrorPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_fetch_flapping_settings = require("@kbn/alerts-ui-shared/src/common/hooks/use_fetch_flapping_settings");
var _react2 = require("@emotion/react");
var _descriptive_form_group = require("@kbn/response-ops-alerts-delete/components/descriptive_form_group");
var _kibana = require("../../../common/lib/kibana");
var _rules_settings_flapping_section = require("./flapping/rules_settings_flapping_section");
var _rules_settings_query_delay_section = require("./query_delay/rules_settings_query_delay_section");
var _use_get_query_delay_settings = require("../../hooks/use_get_query_delay_settings");
var _use_update_rules_settings = require("../../hooks/use_update_rules_settings");
var _center_justified_spinner = require("../center_justified_spinner");
var _get_experimental_features = require("../../../common/get_experimental_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/components/rules_setting/rules_settings_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RulesSettingsErrorPrompt = exports.RulesSettingsErrorPrompt = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "rulesSettingsErrorPrompt",
    color: "danger",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.flyout.errorPromptTitle",
      defaultMessage: "Unable to load your rules settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.flyout.errorPromptBody",
      defaultMessage: "There was an error loading your rules settings. Contact your administrator for help",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  });
});
const useResettableState = initalValue => {
  const initialValueRef = (0, _react.useRef)(initalValue);
  const [value, setValue] = (0, _react.useState)(initalValue);
  const [hasChanged, setHasChanged] = (0, _react.useState)(false);
  const reset = () => {
    setValue(initialValueRef.current);
    setHasChanged(false);
  };
  const updateValue = (next, shouldUpdateInitialValue = false) => {
    setValue(next);
    if (shouldUpdateInitialValue) {
      initialValueRef.current = next;
      setHasChanged(false);
    } else {
      setHasChanged(true);
    }
  };
  return [value, hasChanged, updateValue, reset];
};
const RulesSettingsFlyout = exports.RulesSettingsFlyout = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    isVisible,
    onClose,
    setUpdatingRulesSettings,
    onSave
  } = props;
  const {
    application: {
      capabilities
    },
    notifications,
    isServerless,
    http
  } = (0, _kibana.useKibana)().services;
  const {
    rulesSettings: {
      writeFlappingSettingsUI,
      readFlappingSettingsUI,
      writeQueryDelaySettingsUI,
      readQueryDelaySettingsUI,
      readAlertDeleteSettingsUI,
      writeAlertDeleteSettingsUI
    }
  } = capabilities;
  const [flappingSettings, hasFlappingChanged, setFlappingSettings, resetFlappingSettings] = useResettableState();
  const [queryDelaySettings, hasQueryDelayChanged, setQueryDelaySettings, resetQueryDelaySettings] = useResettableState();
  const {
    isLoading: isFlappingLoading,
    isError: hasFlappingError
  } = (0, _use_fetch_flapping_settings.useFetchFlappingSettings)({
    http,
    enabled: isVisible,
    onSuccess: fetchedSettings => {
      if (!flappingSettings) {
        setFlappingSettings({
          enabled: fetchedSettings.enabled,
          lookBackWindow: fetchedSettings.lookBackWindow,
          statusChangeThreshold: fetchedSettings.statusChangeThreshold
        }, true // Update the initial value so we don't need to fetch it from the server again
        );
      }
    }
  });
  const {
    isLoading: isQueryDelayLoading,
    isError: hasQueryDelayError
  } = (0, _use_get_query_delay_settings.useGetQueryDelaySettings)({
    enabled: isVisible,
    onSuccess: fetchedSettings => {
      if (!queryDelaySettings) {
        setQueryDelaySettings({
          delay: fetchedSettings.delay
        }, true);
      }
    }
  });
  const onCloseFlyout = (0, _react.useCallback)(() => {
    resetFlappingSettings();
    resetQueryDelaySettings();
    onClose();
  }, [onClose, resetFlappingSettings, resetQueryDelaySettings]);
  const {
    mutate
  } = (0, _use_update_rules_settings.useUpdateRuleSettings)({
    onSave,
    onClose,
    setUpdatingRulesSettings
  });

  // In the future when we have more settings sub-features, we should
  // disassociate the rule settings capabilities (save, show) from the
  // sub-feature capabilities (writeXSettingsUI).
  const canWriteFlappingSettings = writeFlappingSettingsUI && !hasFlappingError;
  const canShowFlappingSettings = readFlappingSettingsUI;
  const canWriteQueryDelaySettings = writeQueryDelaySettingsUI && !hasQueryDelayError;
  const canShowQueryDelaySettings = readQueryDelaySettingsUI;
  const canShowAlertDeleteSettings = readAlertDeleteSettingsUI;
  const isChanged = hasFlappingChanged || hasQueryDelayChanged;
  const hasMinimumWritePermissions = canWriteFlappingSettings || canWriteQueryDelaySettings;
  const shouldDisableSaveButton = !isChanged || !hasMinimumWritePermissions;
  const handleSettingsChange = (setting, key, value) => {
    if (setting === 'flapping') {
      if (!flappingSettings) {
        return;
      }
      const newSettings = {
        ...flappingSettings,
        [key]: value
      };
      setFlappingSettings({
        ...newSettings,
        statusChangeThreshold: Math.min(newSettings.lookBackWindow, newSettings.statusChangeThreshold)
      });
    }
    if (setting === 'queryDelay') {
      if (!queryDelaySettings) {
        return;
      }
      const newSettings = {
        ...queryDelaySettings,
        [key]: value
      };
      setQueryDelaySettings(newSettings);
    }
  };
  const handleSave = () => {
    const updatedSettings = {};
    if (canWriteFlappingSettings && hasFlappingChanged) {
      updatedSettings.flapping = flappingSettings;
      setFlappingSettings(flappingSettings, true);
    }
    if (canWriteQueryDelaySettings && hasQueryDelayChanged) {
      updatedSettings.queryDelay = queryDelaySettings;
      setQueryDelaySettings(queryDelaySettings, true);
    }
    mutate(updatedSettings);
  };
  if (!isVisible) {
    return null;
  }
  const maybeRenderForm = () => {
    if (!canShowFlappingSettings && !canShowQueryDelaySettings && !canShowAlertDeleteSettings) {
      return /*#__PURE__*/_react.default.createElement(RulesSettingsErrorPrompt, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 236,
          columnNumber: 14
        }
      });
    }
    if (isFlappingLoading || isQueryDelayLoading) {
      return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 239,
          columnNumber: 14
        }
      });
    }
    const isAlertDeletionSettingsEnabled = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('alertDeletionSettingsEnabled');
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, flappingSettings && /*#__PURE__*/_react.default.createElement(_rules_settings_flapping_section.RulesSettingsFlappingSection, {
      onChange: (key, value) => handleSettingsChange('flapping', key, value),
      settings: flappingSettings,
      canWrite: canWriteFlappingSettings,
      canShow: canShowFlappingSettings,
      hasError: hasFlappingError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 11
      }
    }), isServerless && queryDelaySettings && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_rules_settings_query_delay_section.RulesSettingsQueryDelaySection, {
      onChange: (key, value) => handleSettingsChange('queryDelay', key, value),
      settings: queryDelaySettings,
      canWrite: canWriteQueryDelaySettings,
      canShow: canShowQueryDelaySettings,
      hasError: hasQueryDelayError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 13
      }
    })), isAlertDeletionSettingsEnabled && readAlertDeleteSettingsUI && props.alertDeleteCategoryIds && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_descriptive_form_group.AlertDeleteDescriptiveFormGroup, {
      services: {
        http,
        notifications
      },
      categoryIds: props.alertDeleteCategoryIds,
      isDisabled: !writeAlertDeleteSettingsUI,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 15
      }
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    type: "push",
    "data-test-subj": "rulesSettingsFlyout",
    onClose: onCloseFlyout,
    size: "s",
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.flyout.ruleSettingsLabel', {
      defaultMessage: 'Rule settings'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.flyout.title",
    defaultMessage: "Rule settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    title: _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.flyout.calloutMessage', {
      defaultMessage: 'Apply to all rules within the current space.'
    }),
    css: (0, _react2.css)`
          position: sticky;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 7
    }
  }, maybeRenderForm()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "rulesSettingsFlyoutCancelButton",
    onClick: onCloseFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.flyout.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "rulesSettingsFlyoutSaveButton",
    onClick: handleSave,
    disabled: shouldDisableSaveButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.flyout.saveButton",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 15
    }
  }))))));
});