"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonEditorWithMessageVariables = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _codeEditor = require("@kbn/code-editor");
var _add_message_variables_optional = require("./add_message_variables_optional");
var _lib = require("../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/components/json_editor_with_message_variables.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NO_EDITOR_ERROR_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.components.jsonEditorWithMessageVariable.noEditorErrorTitle', {
  defaultMessage: 'Unable to add message variable'
});
const NO_EDITOR_ERROR_MESSAGE = _i18n.i18n.translate('xpack.triggersActionsUI.components.jsonEditorWithMessageVariable.noEditorErrorMessage', {
  defaultMessage: 'Editor was not found, please refresh page and try again'
});
const {
  useXJsonMode
} = _public.XJson;

// Source ID used to insert text imperatively into the code editor,
// this value is only used to uniquely identify any single edit attempt.
// Multiple editors can use the same ID without any issues.
const EDITOR_SOURCE = 'json-editor-with-message-variables';
const JsonEditorWithMessageVariables = ({
  buttonTitle,
  messageVariables,
  paramsProperty,
  inputTargetValue,
  label,
  errors,
  ariaLabel,
  onDocumentsChange,
  helpText,
  onBlur,
  showButtonTitle,
  dataTestSubj,
  euiCodeEditorProps = {},
  isOptionalField = false,
  readOnly = false
}) => {
  const editorRef = (0, _react.useRef)();
  const editorDisposables = (0, _react.useRef)([]);
  const [showErrorMessage, setShowErrorMessage] = (0, _react.useState)(false);
  const {
    convertToJson,
    setXJson,
    xJson
  } = useXJsonMode(inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : null);
  (0, _react.useEffect)(() => {
    if (!xJson && inputTargetValue) {
      setXJson(inputTargetValue);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [inputTargetValue]);
  const onSelectMessageVariable = variable => {
    if (readOnly) {
      return;
    }
    const editor = editorRef.current;
    if (!editor) {
      setShowErrorMessage(true);
      return;
    }
    const cursorPosition = editor.getSelection();
    const templatedVar = (0, _lib.templateActionVariable)(variable);
    let newValue = '';
    if (cursorPosition) {
      editor.executeEdits(EDITOR_SOURCE, [{
        range: cursorPosition,
        text: templatedVar
      }]);
      newValue = editor.getValue();
    } else {
      newValue = templatedVar;
    }
    setShowErrorMessage(false);
    setXJson(newValue);
    // Keep the documents in sync with the editor content
    onDocumentsChange(convertToJson(newValue));
  };
  const registerEditorListeners = (0, _react.useCallback)(() => {
    const editor = editorRef.current;
    if (!editor) {
      return;
    }
    editorDisposables.current.push(editor.onDidBlurEditorWidget(() => {
      onBlur === null || onBlur === void 0 ? void 0 : onBlur();
    }));
  }, [onBlur]);
  const unregisterEditorListeners = () => {
    editorDisposables.current.forEach(d => {
      d.dispose();
    });
    editorDisposables.current = [];
  };
  const onEditorMount = editor => {
    editorRef.current = editor;
    registerEditorListeners();
  };
  const renderErrorMessage = () => {
    if (!showErrorMessage) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      color: "danger",
      iconType: "warning",
      title: NO_EDITOR_ERROR_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 11
      }
    }, NO_EDITOR_ERROR_MESSAGE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }));
  };
  (0, _react.useEffect)(() => {
    registerEditorListeners();
    return () => unregisterEditorListeners();
  }, [registerEditorListeners]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": dataTestSubj,
    fullWidth: true,
    error: errors,
    isInvalid: errors && errors.length > 0 && inputTargetValue !== undefined,
    label: label,
    labelAppend: /*#__PURE__*/_react.default.createElement(_add_message_variables_optional.AddMessageVariablesOptional, {
      isOptionalField: isOptionalField,
      buttonTitle: buttonTitle,
      messageVariables: messageVariables,
      showButtonTitle: showButtonTitle,
      onSelectEventHandler: onSelectMessageVariable,
      paramsProperty: paramsProperty,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 9
      }
    }),
    helpText: helpText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderErrorMessage(), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, (0, _extends2.default)({
    languageId: _monaco.XJsonLang.ID,
    options: {
      renderValidationDecorations: xJson ? 'on' : 'off',
      // Disable error underline when empty
      lineNumbers: 'on',
      fontSize: 14,
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      folding: true,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true,
      readOnly
    },
    value: xJson,
    width: "100%",
    height: "200px",
    "data-test-subj": `${paramsProperty}JsonEditor${readOnly ? 'ReadOnly' : ''}`,
    "aria-label": ariaLabel
  }, euiCodeEditorProps, {
    editorDidMount: onEditorMount,
    onChange: xjson => {
      setXJson(xjson);
      // Keep the documents in sync with the editor content
      onDocumentsChange(convertToJson(xjson));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }))));
};
exports.JsonEditorWithMessageVariables = JsonEditorWithMessageVariables;