"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoute = registerRoute;
var _schedule_now_transforms = require("../../api_schemas/schedule_now_transforms");
var _constants = require("../../../../common/constants");
var _route_handler = require("./route_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoute({
  router,
  getLicense
}) {
  /**
   * @apiGroup Transforms
   *
   * @api {post} /internal/transform/schedule_now_transforms Schedules transforms now
   * @apiName PostScheduleNowTransforms
   * @apiDescription Schedules transforms now
   *
   * @apiSchema (body) scheduleNowTransformsRequestSchema
   */
  router.versioned.post({
    path: (0, _constants.addInternalBasePath)('schedule_now_transforms'),
    access: 'internal',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization because permissions will be checked by elasticsearch'
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: _schedule_now_transforms.scheduleNowTransformsRequestSchema
      }
    }
  }, async (ctx, request, response) => {
    const license = await getLicense();
    return license.guardApiRoute(_route_handler.routeHandler)(ctx, request, response);
  });
}