"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateTransformButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _create_capability_failure_message = require("../../../../../../common/utils/create_capability_failure_message");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/create_transform_button/create_transform_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CreateTransformButton = ({
  onClick,
  transformNodes
}) => {
  const capabilities = (0, _hooks.useTransformCapabilities)();
  const disabled = !capabilities.canCreateTransform || !capabilities.canPreviewTransform || !capabilities.canStartStopTransform || transformNodes === 0;
  const createTransformButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: disabled,
    fill: true,
    onClick: onClick,
    iconType: "plusInCircle",
    "data-test-subj": "transformButtonCreate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.transformList.createTransformButton",
    defaultMessage: "Create a transform",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }));
  if (disabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: (0, _create_capability_failure_message.createCapabilityFailureMessage)(transformNodes > 0 ? 'canCreateTransform' : 'noTransformNodes'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 7
      }
    }, createTransformButton);
  }
  return createTransformButton;
};
exports.CreateTransformButton = CreateTransformButton;