"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateAlertRuleAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../../../../hooks");
var _create_alert_rule_action_name = require("./create_alert_rule_action_name");
var _transform_alerting_flyout = require("../../../../../alerting/transform_alerting_flyout");
var _transform = require("../../../../../../common/types/transform");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/action_create_alert/use_create_alert_rule_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useCreateAlertRuleAction = forceDisable => {
  const {
    canCreateTransformAlerts
  } = (0, _hooks.useTransformCapabilities)();
  const {
    setCreateAlertRule
  } = (0, _transform_alerting_flyout.useAlertRuleFlyout)();
  const clickHandler = (0, _react.useCallback)(item => {
    setCreateAlertRule(item.id);
  }, [setCreateAlertRule]);
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_create_alert_rule_action_name.CreateAlertRuleActionName, {
      disabled: !canCreateTransformAlerts,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 9
      }
    }),
    available: item => (0, _transform.isContinuousTransform)(item.config),
    enabled: () => canCreateTransformAlerts && !forceDisable,
    description: _create_alert_rule_action_name.crateAlertRuleActionNameText,
    type: 'icon',
    icon: 'bell',
    onClick: clickHandler,
    'data-test-subj': 'transformActionCreateAlertRule'
  }), [canCreateTransformAlerts, forceDisable, clickHandler]);
  return {
    action
  };
};
exports.useCreateAlertRuleAction = useCreateAlertRuleAction;