"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFormField = exports.selectFormFields = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectFormFields = s => s.formFields;
exports.selectFormFields = selectFormFields;
const createSelectFormField = field => s => s.formFields[field];
const useFormField = field => {
  const selectFormField = (0, _react.useMemo)(() => createSelectFormField(field), [field]);
  return (0, _reactRedux.useSelector)(selectFormField);
};
exports.useFormField = useFormField;