"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformUpdateButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _errors = require("../../../../../common/utils/errors");
var _hooks = require("../../../hooks");
var _edit_transform_flyout_state = require("../state_management/edit_transform_flyout_state");
var _is_form_touched = require("../state_management/selectors/is_form_touched");
var _is_form_valid = require("../state_management/selectors/is_form_valid");
var _updated_transform_config = require("../state_management/selectors/updated_transform_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/edit_transform/components/edit_transform_update_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EditTransformUpdateButton = ({
  closeFlyout
}) => {
  const {
    config
  } = (0, _edit_transform_flyout_state.useEditTransformFlyoutContext)();
  const isFormValid = (0, _is_form_valid.useIsFormValid)();
  const isFormTouched = (0, _is_form_touched.useIsFormTouched)();
  const requestConfig = (0, _updated_transform_config.useUpdatedTransformConfig)();
  const isUpdateButtonDisabled = !isFormValid || !isFormTouched;
  const {
    setApiError
  } = (0, _edit_transform_flyout_state.useEditTransformFlyoutActions)();
  const updateTransfrom = (0, _hooks.useUpdateTransform)(config.id, requestConfig);
  async function submitFormHandler() {
    setApiError(undefined);
    updateTransfrom(undefined, {
      onError: error => setApiError((0, _errors.getErrorMessage)(error)),
      onSuccess: () => closeFlyout()
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "transformEditFlyoutUpdateButton",
    onClick: submitFormHandler,
    fill: true,
    isDisabled: isUpdateButtonDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.transform.transformList.editFlyoutUpdateButtonText', {
    defaultMessage: 'Update'
  }));
};
exports.EditTransformUpdateButton = EditTransformUpdateButton;