"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwitchModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/switch_modal/switch_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const pivotModalTitle = _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorSwitchModalTitle', {
  defaultMessage: 'Unapplied changes'
});
const sourceModalTitle = _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedSourceEditorSwitchModalTitle', {
  defaultMessage: 'Edits will be lost'
});
const pivotModalMessage = _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorSwitchModalBodyText', {
  defaultMessage: `The changes in the advanced editor haven't been applied yet. By disabling the advanced editor you will lose your edits.`
});
const sourceModalMessage = _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedSourceEditorSwitchModalBodyText', {
  defaultMessage: `By switching back to the query bar you will lose your edits.`
});
const pivotModalConfirmButtonText = _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorSwitchModalConfirmButtonText', {
  defaultMessage: 'Disable advanced editor'
});
const sourceModalConfirmButtonText = _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedSourceEditorSwitchModalConfirmButtonText', {
  defaultMessage: 'Switch to query bar'
});
const cancelButtonText = _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorSwitchModalCancelButtonText', {
  defaultMessage: 'Cancel'
});
const SwitchModal = ({
  onCancel,
  onConfirm,
  type
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: type === 'pivot' ? pivotModalTitle : sourceModalTitle,
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: cancelButtonText,
    confirmButtonText: type === 'pivot' ? pivotModalConfirmButtonText : sourceModalConfirmButtonText,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, type === 'pivot' ? pivotModalMessage : sourceModalMessage));
};
exports.SwitchModal = SwitchModal;