"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformFunctionSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/step_define/transform_function_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TransformFunctionSelector = ({
  selectedFunction,
  onChange
}) => {
  const transformFunctions = [{
    name: _constants.TRANSFORM_FUNCTION.PIVOT,
    helpText: _i18n.i18n.translate('xpack.transform.stepDefineForm.pivotHelperText', {
      defaultMessage: 'Aggregate and group your data.'
    }),
    icon: 'aggregate',
    title: _i18n.i18n.translate('xpack.transform.stepDefineForm.pivotLabel', {
      defaultMessage: 'Pivot'
    })
  }, {
    name: _constants.TRANSFORM_FUNCTION.LATEST,
    helpText: _i18n.i18n.translate('xpack.transform.stepDefineForm.latestHelperText', {
      defaultMessage: 'Keep track of your most recent data.'
    }),
    icon: 'clock',
    title: _i18n.i18n.translate('xpack.transform.stepDefineForm.latestLabel', {
      defaultMessage: 'Latest'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    "data-test-subj": "transformFunctionSelection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, transformFunctions.map(({
    helpText,
    icon,
    name,
    title
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: name,
    style: {
      width: 320
    },
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: icon,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 21
      }
    }),
    title: title,
    description: helpText,
    "data-test-subj": `transformCreation-${name}-option${selectedFunction === name ? ' selectedFunction' : ''}`,
    selectable: {
      onClick: () => {
        // Only allow one function selected at a time and don't allow deselection
        if (selectedFunction === name) {
          return;
        }
        onChange(name);
      },
      isSelected: selectedFunction === name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }));
};
exports.TransformFunctionSelector = TransformFunctionSelector;