"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDefineForm = exports.ConfigSectionTitle = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDataGrid = require("@kbn/ml-data-grid");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlUrlState = require("@kbn/ml-url-state");
var _mlFieldStatsFlyout = require("@kbn/ml-field-stats-flyout");
var _common = require("@kbn/ml-data-grid/lib/common");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _storage = require("../../../../../../common/types/storage");
var _data_grid = require("../../../../common/data_grid");
var _common2 = require("../../../../common");
var _use_documentation_links = require("../../../../hooks/use_documentation_links");
var _use_index_data = require("../../../../hooks/use_index_data");
var _use_transform_config_data = require("../../../../hooks/use_transform_config_data");
var _app_dependencies = require("../../../../app_dependencies");
var _pivot_aggs = require("../../../../common/pivot_aggs");
var _advanced_query_editor_switch = require("../advanced_query_editor_switch");
var _advanced_source_editor = require("../advanced_source_editor");
var _date_picker_apply_switch = require("../date_picker_apply_switch");
var _source_search_bar = require("../source_search_bar");
var _advanced_runtime_mappings_settings = require("../advanced_runtime_mappings_settings");
var _use_step_define_form = require("./hooks/use_step_define_form");
var _transform_function_selector = require("./transform_function_selector");
var _latest_function_form = require("./latest_function_form");
var _pivot_function_form = require("./pivot_function_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/step_define/step_define_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALLOW_TIME_RANGE_ON_TRANSFORM_CONFIG = false;
const advancedEditorsSidebarWidth = '220px';
const isPopulatedFields = arg => arg instanceof Set;
const ConfigSectionTitle = ({
  title
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 90,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 91,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("span", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 92,
    columnNumber: 7
  }
}, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 5
  }
}));
exports.ConfigSectionTitle = ConfigSectionTitle;
const StepDefineForm = exports.StepDefineForm = /*#__PURE__*/_react.default.memo(props => {
  var _searchItems$savedSea, _searchItems$savedSea2;
  const [globalState, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const {
    searchItems
  } = props;
  const {
    dataView
  } = searchItems;
  const indexPattern = (0, _react.useMemo)(() => dataView.getIndexPattern(), [dataView]);
  const [frozenDataPreference, setFrozenDataPreference] = (0, _mlLocalStorage.useStorage)(_storage.TRANSFORM_FROZEN_TIER_PREFERENCE,
  // By default we will exclude frozen data tier
  _mlDatePicker.FROZEN_TIER_PREFERENCE.EXCLUDE);
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const stepDefineForm = (0, _use_step_define_form.useStepDefineForm)(props);
  const {
    advancedEditorConfig
  } = stepDefineForm.advancedPivotEditor.state;
  const {
    advancedEditorSourceConfig,
    isAdvancedSourceEditorEnabled,
    isAdvancedSourceEditorApplyButtonEnabled
  } = stepDefineForm.advancedSourceEditor.state;
  const {
    isDatePickerApplyEnabled,
    timeRangeMs
  } = stepDefineForm.datePicker.state;
  const {
    transformConfigQuery
  } = stepDefineForm.searchBar.state;
  const {
    runtimeMappings
  } = stepDefineForm.runtimeMappingsEditor.state;
  const fieldStatsContext = (0, _mlFieldStatsFlyout.useFieldStatsFlyoutContext)();
  const populatedFields = (0, _react.useMemo)(() => isPopulatedFields(fieldStatsContext === null || fieldStatsContext === void 0 ? void 0 : fieldStatsContext.populatedFields) ? [...fieldStatsContext.populatedFields] : [], [fieldStatsContext === null || fieldStatsContext === void 0 ? void 0 : fieldStatsContext.populatedFields]);
  const indexPreviewProps = {
    ...(0, _use_index_data.useIndexData)({
      dataView,
      query: transformConfigQuery,
      populatedFields,
      combinedRuntimeMappings: runtimeMappings,
      timeRangeMs
    }),
    dataTestSubj: 'transformIndexPreview',
    toastNotifications
  };
  const {
    requestPayload,
    validationStatus
  } = stepDefineForm.transformFunction === _constants.TRANSFORM_FUNCTION.PIVOT ? stepDefineForm.pivotConfig.state : stepDefineForm.latestFunctionConfig;
  const copyToClipboardSource = (0, _data_grid.getIndexDevConsoleStatement)(transformConfigQuery, indexPattern);
  const copyToClipboardSourceDescription = _i18n.i18n.translate('xpack.transform.indexPreview.copyClipboardTooltip', {
    defaultMessage: 'Copy Dev Console statement of the index preview to the clipboard.'
  });
  const copyToClipboardPreviewRequest = (0, _common2.getPreviewTransformRequestBody)(dataView, transformConfigQuery, requestPayload, runtimeMappings, isDatePickerApplyEnabled ? timeRangeMs : undefined);
  const copyToClipboardPivot = (0, _data_grid.getTransformPreviewDevConsoleStatement)(copyToClipboardPreviewRequest);
  const copyToClipboardPivotDescription = _i18n.i18n.translate('xpack.transform.pivotPreview.copyClipboardTooltip', {
    defaultMessage: 'Copy Dev Console statement of the transform preview to the clipboard.'
  });
  const previewProps = {
    ...(0, _use_transform_config_data.useTransformConfigData)(dataView, transformConfigQuery, validationStatus, requestPayload, runtimeMappings, timeRangeMs),
    dataTestSubj: 'transformPivotPreview',
    toastNotifications,
    ...(stepDefineForm.transformFunction === _constants.TRANSFORM_FUNCTION.LATEST ? {
      copyToClipboard: copyToClipboardPivot,
      copyToClipboardDescription: copyToClipboardPivotDescription
    } : {})
  };
  const applySourceChangesHandler = () => {
    const sourceConfig = JSON.parse(advancedEditorSourceConfig);
    stepDefineForm.searchBar.actions.setSearchQuery(sourceConfig);
    stepDefineForm.advancedSourceEditor.actions.applyAdvancedSourceEditorChanges();
  };
  const applyPivotChangesHandler = () => {
    const pivot = JSON.parse(stepDefineForm.advancedPivotEditor.actions.convertToJson(advancedEditorConfig));
    const newGroupByList = {};
    if (pivot !== undefined && pivot.group_by !== undefined) {
      Object.entries(pivot.group_by).forEach(d => {
        const aggName = d[0];
        const aggConfig = d[1];
        const aggConfigKeys = Object.keys(aggConfig);
        const agg = aggConfigKeys[0];
        newGroupByList[aggName] = {
          ...aggConfig[agg],
          agg,
          aggName,
          dropDownName: ''
        };
      });
    }
    stepDefineForm.pivotConfig.actions.setGroupByList(newGroupByList);
    const newAggList = {};
    if (pivot !== undefined && pivot.aggregations !== undefined) {
      Object.entries(pivot.aggregations).forEach(d => {
        const aggName = d[0];
        const aggConfig = d[1];
        newAggList[aggName] = (0, _pivot_aggs.getAggConfigFromEsAgg)(aggConfig, aggName);
      });
    }
    stepDefineForm.pivotConfig.actions.setAggList(newAggList);
    stepDefineForm.advancedPivotEditor.actions.setAdvancedEditorConfigLastApplied(advancedEditorConfig);
    stepDefineForm.advancedPivotEditor.actions.setAdvancedPivotEditorApplyButtonEnabled(false);
  };
  const {
    esQueryDsl
  } = (0, _use_documentation_links.useDocumentationLinks)();
  const hasValidTimeField = (0, _react.useMemo)(() => dataView.timeFieldName !== undefined && dataView.timeFieldName !== '', [dataView.timeFieldName]);
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: (dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName) !== undefined,
    autoRefreshSelector: false
  });
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.time) !== undefined) {
      timefilter.setTime({
        from: globalState.time.from,
        to: globalState.time.to
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.time), timefilter]);
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined) {
      timefilter.setRefreshInterval(globalState.refreshInterval);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval), timefilter]);
  (0, _react.useEffect)(() => {
    const timeUpdateSubscription = (0, _rxjs.merge)(timefilter.getAutoRefreshFetch$(), timefilter.getTimeUpdate$(), _mlDatePicker.mlTimefilterRefresh$).subscribe(() => {
      if (setGlobalState) {
        setGlobalState({
          time: timefilter.getTime(),
          refreshInterval: timefilter.getRefreshInterval()
        });
      }
    });
    return () => {
      timeUpdateSubscription.unsubscribe();
    };
  });
  const rowCountInfoLabel = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.stepDefineForm.rowCountInfoLabel",
    defaultMessage: "Results are limited to a maximum of {maxRowCount} for preview purposes",
    values: {
      maxRowCount: _common.MAX_ROW_COUNT
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformStepDefineForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_transform_function_selector.TransformFunctionSelector, {
    selectedFunction: stepDefineForm.transformFunction,
    onChange: stepDefineForm.setTransformFunction,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(ConfigSectionTitle, {
    title: "Source data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 9
    }
  }), searchItems.savedSearch === undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.dataViewLabel', {
      defaultMessage: 'Data view'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 13
    }
  }, indexPattern)), hasValidTimeField && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.transform.stepDefineForm.datePickerLabel', {
      defaultMessage: 'Time range'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.transform.stepDefineForm.datePickerIconTipContent', {
        defaultMessage: 'The time range is applied to previews only and will not be part of the final transform configuration.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 331,
        columnNumber: 17
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerWrapper, {
    isAutoRefreshOnly: !hasValidTimeField,
    showRefresh: !hasValidTimeField,
    width: "full",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: advancedEditorsSidebarWidth
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 15
    }
  }, ALLOW_TIME_RANGE_ON_TRANSFORM_CONFIG && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 21
    }
  }, searchItems.savedSearch === undefined && /*#__PURE__*/_react.default.createElement(_date_picker_apply_switch.DatePickerApplySwitch, (0, _extends2.default)({}, stepDefineForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 25
    }
  })))), /*#__PURE__*/_react.default.createElement(_mlDatePicker.FullTimeRangeSelector, {
    frozenDataPreference: frozenDataPreference,
    setFrozenDataPreference: setFrozenDataPreference,
    dataView: dataView,
    query: undefined,
    disabled: false,
    timefilter: timefilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: (searchItems === null || searchItems === void 0 ? void 0 : (_searchItems$savedSea = searchItems.savedSearch) === null || _searchItems$savedSea === void 0 ? void 0 : _searchItems$savedSea.id) !== undefined ? _i18n.i18n.translate('xpack.transform.stepDefineForm.discoverSessionLabel', {
      defaultMessage: 'Discover session'
    }) : _i18n.i18n.translate('xpack.transform.stepDefineForm.searchFilterLabel', {
      defaultMessage: 'Search filter'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 15
    }
  }, searchItems.savedSearch === undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isAdvancedSourceEditorEnabled && /*#__PURE__*/_react.default.createElement(_source_search_bar.SourceSearchBar, {
    dataView: dataView,
    searchBar: stepDefineForm.searchBar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 395,
      columnNumber: 23
    }
  }), isAdvancedSourceEditorEnabled && /*#__PURE__*/_react.default.createElement(_advanced_source_editor.AdvancedSourceEditor, (0, _extends2.default)({}, stepDefineForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 55
    }
  }))), (searchItems === null || searchItems === void 0 ? void 0 : (_searchItems$savedSea2 = searchItems.savedSearch) === null || _searchItems$savedSea2 === void 0 ? void 0 : _searchItems$savedSea2.id) !== undefined && /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 19
    }
  }, searchItems.savedSearch.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: advancedEditorsSidebarWidth
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 408,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 409,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 410,
      columnNumber: 23
    }
  }, searchItems.savedSearch === undefined && /*#__PURE__*/_react.default.createElement(_advanced_query_editor_switch.AdvancedQueryEditorSwitch, (0, _extends2.default)({}, stepDefineForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 27
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 415,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: copyToClipboardSourceDescription,
    textToCopy: copyToClipboardSource,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 416,
      columnNumber: 25
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": copyToClipboardSourceDescription,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 29
    }
  }))))), isAdvancedSourceEditorEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: advancedEditorsSidebarWidth
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 432,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 433,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedSourceEditorHelpText', {
    defaultMessage: 'The advanced editor allows you to edit the source query clause of the transform configuration.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: esQueryDsl,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 25
    }
  }, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorHelpTextLink', {
    defaultMessage: 'Learn more about available options.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 451,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    style: {
      width: 'fit-content'
    },
    size: "s",
    fill: true,
    onClick: applySourceChangesHandler,
    disabled: !isAdvancedSourceEditorApplyButtonEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 452,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedSourceEditorApplyButtonText', {
    defaultMessage: 'Apply changes'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 471,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_advanced_runtime_mappings_settings.AdvancedRuntimeMappingsSettings, (0, _extends2.default)({}, stepDefineForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 472,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 473,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.dataGridLabel', {
      defaultMessage: 'Source documents'
    }),
    labelAppend: indexPreviewProps.rowCount === _common.MAX_ROW_COUNT && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 482,
        columnNumber: 19
      }
    }, rowCountInfoLabel),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 475,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_mlDataGrid.DataGrid, (0, _extends2.default)({}, indexPreviewProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 486,
      columnNumber: 15
    }
  })))))), /*#__PURE__*/_react.default.createElement(ConfigSectionTitle, {
    title: "Transform configuration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 492,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 494,
      columnNumber: 7
    }
  }, stepDefineForm.transformFunction === _constants.TRANSFORM_FUNCTION.PIVOT ? /*#__PURE__*/_react.default.createElement(_pivot_function_form.PivotFunctionForm, {
    applyPivotChangesHandler,
    copyToClipboardPivot,
    copyToClipboardPivotDescription,
    stepDefineForm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 11
    }
  }) : null, stepDefineForm.transformFunction === _constants.TRANSFORM_FUNCTION.LATEST ? /*#__PURE__*/_react.default.createElement(_latest_function_form.LatestFunctionForm, {
    copyToClipboard: copyToClipboardPivot,
    copyToClipboardDescription: copyToClipboardPivotDescription,
    latestFunctionService: stepDefineForm.latestFunctionConfig,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 506,
      columnNumber: 11
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 513,
      columnNumber: 7
    }
  }), (stepDefineForm.transformFunction !== _constants.TRANSFORM_FUNCTION.LATEST || stepDefineForm.latestFunctionConfig.sortFieldOptions.length > 0) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.previewLabel', {
      defaultMessage: 'Preview'
    }),
    labelAppend: previewProps.rowCount === _common.MAX_ROW_COUNT && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 523,
        columnNumber: 15
      }
    }, rowCountInfoLabel),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 516,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_mlDataGrid.DataGrid, (0, _extends2.default)({}, previewProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 528,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 529,
      columnNumber: 13
    }
  }))));
});