"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepDefineForm = void 0;
var _react = require("react");
var _common = require("../../../../../common");
var _common2 = require("../common");
var _use_advanced_pivot_editor = require("./use_advanced_pivot_editor");
var _use_advanced_source_editor = require("./use_advanced_source_editor");
var _use_date_picker = require("./use_date_picker");
var _use_pivot_config = require("./use_pivot_config");
var _use_search_bar = require("./use_search_bar");
var _use_latest_function_config = require("./use_latest_function_config");
var _constants = require("../../../../../../../common/constants");
var _use_advanced_runtime_mappings_editor = require("./use_advanced_runtime_mappings_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStepDefineForm = ({
  overrides,
  onChange,
  searchItems
}) => {
  const defaults = {
    ...(0, _common2.getDefaultStepDefineState)(searchItems),
    ...overrides
  };
  const {
    dataView
  } = searchItems;
  const [transformFunction, setTransformFunction] = (0, _react.useState)(defaults.transformFunction);
  const datePicker = (0, _use_date_picker.useDatePicker)(defaults, dataView);
  const searchBar = (0, _use_search_bar.useSearchBar)(defaults, dataView);
  const pivotConfig = (0, _use_pivot_config.usePivotConfig)(defaults, dataView);
  const latestFunctionConfig = (0, _use_latest_function_config.useLatestFunctionConfig)(defaults.latestConfig, dataView, defaults === null || defaults === void 0 ? void 0 : defaults.runtimeMappings);
  const previewRequest = (0, _common.getPreviewTransformRequestBody)(dataView, searchBar.state.transformConfigQuery, pivotConfig.state.requestPayload, defaults === null || defaults === void 0 ? void 0 : defaults.runtimeMappings);

  // pivot config hook
  const advancedPivotEditor = (0, _use_advanced_pivot_editor.useAdvancedPivotEditor)(defaults, previewRequest);

  // source config hook
  const advancedSourceEditor = (0, _use_advanced_source_editor.useAdvancedSourceEditor)(defaults, previewRequest);

  // runtime fields config hook
  const runtimeMappingsEditor = (0, _use_advanced_runtime_mappings_editor.useAdvancedRuntimeMappingsEditor)(defaults);
  (0, _react.useEffect)(() => {
    const runtimeMappings = runtimeMappingsEditor.state.runtimeMappings;
    if (!advancedSourceEditor.state.isAdvancedSourceEditorEnabled) {
      const previewRequestUpdate = (0, _common.getPreviewTransformRequestBody)(dataView, searchBar.state.transformConfigQuery, pivotConfig.state.requestPayload, runtimeMappings);
      const stringifiedSourceConfigUpdate = JSON.stringify(previewRequestUpdate.source.query, null, 2);
      advancedSourceEditor.actions.setAdvancedEditorSourceConfig(stringifiedSourceConfigUpdate);
    }
    onChange({
      transformFunction,
      latestConfig: latestFunctionConfig.config,
      aggList: pivotConfig.state.aggList,
      groupByList: pivotConfig.state.groupByList,
      isAdvancedPivotEditorEnabled: advancedPivotEditor.state.isAdvancedPivotEditorEnabled,
      isAdvancedSourceEditorEnabled: advancedSourceEditor.state.isAdvancedSourceEditorEnabled,
      isDatePickerApplyEnabled: datePicker.state.isDatePickerApplyEnabled,
      searchLanguage: searchBar.state.searchLanguage,
      searchString: searchBar.state.searchString,
      searchQuery: searchBar.state.searchQuery,
      sourceConfigUpdated: advancedSourceEditor.state.sourceConfigUpdated,
      valid: transformFunction === _constants.TRANSFORM_FUNCTION.PIVOT ? pivotConfig.state.validationStatus.isValid : latestFunctionConfig.validationStatus.isValid,
      validationStatus: transformFunction === _constants.TRANSFORM_FUNCTION.PIVOT ? pivotConfig.state.validationStatus : latestFunctionConfig.validationStatus,
      previewRequest: transformFunction === _constants.TRANSFORM_FUNCTION.PIVOT ? pivotConfig.state.requestPayload : latestFunctionConfig.requestPayload,
      runtimeMappings,
      runtimeMappingsUpdated: runtimeMappingsEditor.state.runtimeMappingsUpdated,
      isRuntimeMappingsEditorEnabled: runtimeMappingsEditor.state.isRuntimeMappingsEditorEnabled,
      timeRangeMs: datePicker.state.timeRangeMs
    });
    // custom comparison
    /* eslint-disable react-hooks/exhaustive-deps */
  }, [JSON.stringify(advancedPivotEditor.state), JSON.stringify(advancedSourceEditor.state), JSON.stringify(datePicker.state), pivotConfig.state, JSON.stringify(searchBar.state), JSON.stringify([runtimeMappingsEditor.state.runtimeMappings, runtimeMappingsEditor.state.runtimeMappingsUpdated, runtimeMappingsEditor.state.isRuntimeMappingsEditorEnabled]), latestFunctionConfig.config, transformFunction]);
  return {
    transformFunction,
    setTransformFunction,
    advancedPivotEditor,
    advancedSourceEditor,
    runtimeMappingsEditor,
    datePicker,
    pivotConfig,
    latestFunctionConfig,
    searchBar
  };
};
exports.useStepDefineForm = useStepDefineForm;