"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggLabelForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _common = require("../../../../common");
var _popover_form = require("./popover_form");
var _pivot_aggs = require("../../../../common/pivot_aggs");
var _sub_aggs_section = require("./sub_aggs_section");
var _styles = require("../../styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/aggregation_list/agg_label_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = () => {
  return {
    transformAggHelperText: (0, _react2.css)`
      line-height: 20px;
    `
  };
};
const AggLabelForm = ({
  deleteHandler,
  item,
  otherAggNames,
  onChange,
  options
}) => {
  const intervalButtonStyles = (0, _styles.useIntervalButtonStyles)();
  const styles = useStyles();
  const [isPopoverVisible, setPopoverVisibility] = (0, _react.useState)((0, _pivot_aggs.isPivotAggsWithExtendedForm)(item) && !item.isValid());
  function update(updateItem) {
    onChange({
      ...updateItem
    });
    setPopoverVisibility(false);
  }
  const helperText = (0, _pivot_aggs.isPivotAggsWithExtendedForm)(item) && item.helperText && item.helperText();
  const isSubAggSupported = (0, _common.isPivotAggsConfigWithUiBase)(item) && item.isSubAggsSupported && ((0, _pivot_aggs.isPivotAggsWithExtendedForm)(item) ? item.isValid() : true);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _styles.transformLabelStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate",
    "data-test-subj": "transformAggregationEntryLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, item.aggName)), helperText && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    css: styles.transformAggHelperText,
    className: "eui-textTruncate",
    "data-test-subj": "transformAggHelperText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, helperText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: intervalButtonStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "transformFormPopover",
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.transform.aggLabelForm.editAggAriaLabel', {
        defaultMessage: 'Edit aggregation'
      }),
      size: "s",
      iconType: "pencil",
      onClick: () => setPopoverVisibility(!isPopoverVisible),
      "data-test-subj": `transformAggregationEntryEditButton_${item.aggName}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 15
      }
    }),
    isOpen: isPopoverVisible,
    closePopover: () => setPopoverVisibility(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_popover_form.PopoverForm, {
    defaultData: item,
    onChange: update,
    otherAggNames: otherAggNames,
    options: options,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: intervalButtonStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.transform.aggLabelForm.deleteItemAriaLabel', {
      defaultMessage: 'Delete item'
    }),
    size: "s",
    iconType: "cross",
    onClick: () => deleteHandler(item.aggName),
    "data-test-subj": "transformAggregationEntryDeleteButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }))), isSubAggSupported && /*#__PURE__*/_react.default.createElement(_sub_aggs_section.SubAggsSection, {
    item: item,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 29
    }
  }));
};
exports.AggLabelForm = AggLabelForm;