"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedRuntimeMappingsSettings = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _advanced_runtime_mappings_editor = require("../advanced_runtime_mappings_editor/advanced_runtime_mappings_editor");
var _advanced_runtime_mappings_editor_switch = require("../advanced_runtime_mappings_editor_switch");
var _common = require("../../../../common");
var _pivot_group_by = require("../../../../common/pivot_group_by");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/advanced_runtime_mappings_settings/advanced_runtime_mappings_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const advancedEditorsSidebarWidth = '220px';
const COPY_TO_CLIPBOARD_RUNTIME_MAPPINGS = _i18n.i18n.translate('xpack.transform.indexPreview.copyRuntimeFieldsClipboardTooltip', {
  defaultMessage: 'Copy Dev Console statement of the runtime fields to the clipboard.'
});
const AdvancedRuntimeMappingsSettings = props => {
  const {
    actions: {
      applyRuntimeMappingsEditorChanges
    },
    state: {
      runtimeMappings,
      advancedRuntimeMappingsConfig,
      isRuntimeMappingsEditorApplyButtonEnabled,
      isRuntimeMappingsEditorEnabled
    }
  } = props.runtimeMappingsEditor;
  const {
    actions: {
      deleteAggregation,
      deleteGroupBy,
      updateAggregation
    },
    state: {
      groupByList,
      aggList
    }
  } = props.pivotConfig;
  const applyChanges = () => {
    const nextConfig = advancedRuntimeMappingsConfig === '' ? {} : JSON.parse(advancedRuntimeMappingsConfig);
    const previousConfig = runtimeMappings;
    const isFieldDeleted = field => Object.hasOwn(previousConfig !== null && previousConfig !== void 0 ? previousConfig : {}, field) && !Object.hasOwn(nextConfig, field);
    applyRuntimeMappingsEditorChanges();

    // If the user updates the name of the runtime mapping fields
    // delete any groupBy or aggregation associated with the deleted field
    Object.keys(groupByList).forEach(groupByKey => {
      const groupBy = groupByList[groupByKey];
      if ((0, _common.isPivotGroupByConfigWithUiSupport)(groupBy) && Object.hasOwn(previousConfig !== null && previousConfig !== void 0 ? previousConfig : {}, groupBy.field) && !Object.hasOwn(nextConfig, groupBy.field)) {
        deleteGroupBy(groupByKey);
      }
    });
    Object.keys(aggList).forEach(aggName => {
      const agg = aggList[aggName];
      if ((0, _pivot_group_by.isPivotAggConfigWithUiSupport)(agg)) {
        if (Array.isArray(agg.field)) {
          const newFields = agg.field.filter(f => !isFieldDeleted(f));
          updateAggregation(aggName, {
            ...agg,
            field: newFields
          });
        } else {
          if ((0, _mlIsDefined.isDefined)(agg.field) && isFieldDeleted(agg.field)) {
            deleteAggregation(aggName);
          }
        }
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.runtimeFieldsLabel', {
      defaultMessage: 'Runtime fields'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, runtimeMappings !== undefined && Object.keys(runtimeMappings).length > 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.stepDefineForm.runtimeFieldsListLabel",
    defaultMessage: "{runtimeFields}",
    values: {
      runtimeFields: Object.keys(runtimeMappings).join(',')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.stepDefineForm.noRuntimeMappingsLabel",
    defaultMessage: "No runtime field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }), isRuntimeMappingsEditorEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_advanced_runtime_mappings_editor.AdvancedRuntimeMappingsEditor, (0, _extends2.default)({}, props.runtimeMappingsEditor, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: advancedEditorsSidebarWidth
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_advanced_runtime_mappings_editor_switch.AdvancedRuntimeMappingsEditorSwitch, (0, _extends2.default)({}, props.runtimeMappingsEditor, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: COPY_TO_CLIPBOARD_RUNTIME_MAPPINGS,
    textToCopy: advancedRuntimeMappingsConfig !== null && advancedRuntimeMappingsConfig !== void 0 ? advancedRuntimeMappingsConfig : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 21
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": COPY_TO_CLIPBOARD_RUNTIME_MAPPINGS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 25
    }
  }))))), isRuntimeMappingsEditorEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: advancedEditorsSidebarWidth
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedRuntimeFieldsEditorHelpText', {
    defaultMessage: 'The advanced editor allows you to edit the runtime fields of the transform configuration.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    style: {
      width: 'fit-content'
    },
    size: "s",
    fill: true,
    onClick: applyChanges,
    disabled: !isRuntimeMappingsEditorApplyButtonEnabled,
    "data-test-subj": "transformRuntimeMappingsApplyButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedSourceEditorApplyButtonText', {
    defaultMessage: 'Apply changes'
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }));
};
exports.AdvancedRuntimeMappingsSettings = AdvancedRuntimeMappingsSettings;