"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedRuntimeMappingsEditorSwitch = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _switch_modal = require("./switch_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/advanced_runtime_mappings_editor_switch/advanced_runtime_mappings_editor_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AdvancedRuntimeMappingsEditorSwitch = props => {
  const {
    actions: {
      toggleRuntimeMappingsEditor,
      setRuntimeMappingsEditorSwitchModalVisible
    },
    state: {
      isRuntimeMappingsEditorEnabled,
      isRuntimeMappingsEditorSwitchModalVisible,
      advancedEditorRuntimeMappingsLastApplied,
      advancedRuntimeMappingsConfig
    }
  } = props;

  // If switching to KQL after updating via editor - reset search
  const toggleEditorHandler = (reset = false) => {
    toggleRuntimeMappingsEditor(reset);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorRuntimeFieldsSwitchLabel', {
      defaultMessage: 'Edit runtime fields'
    }),
    checked: isRuntimeMappingsEditorEnabled,
    onChange: () => {
      if (isRuntimeMappingsEditorEnabled && advancedRuntimeMappingsConfig !== advancedEditorRuntimeMappingsLastApplied) {
        setRuntimeMappingsEditorSwitchModalVisible(true);
        return;
      }
      toggleEditorHandler();
    },
    "data-test-subj": "transformAdvancedRuntimeMappingsEditorSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }), isRuntimeMappingsEditorSwitchModalVisible && /*#__PURE__*/_react.default.createElement(_switch_modal.SwitchModal, {
    onCancel: () => setRuntimeMappingsEditorSwitchModalVisible(false),
    onConfirm: () => {
      setRuntimeMappingsEditorSwitchModalVisible(false);
      toggleEditorHandler(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }));
};
exports.AdvancedRuntimeMappingsEditorSwitch = AdvancedRuntimeMappingsEditorSwitch;