"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.frequencyValidator = void 0;
var _messages = require("./messages");
var _parse_duration_above_zero = require("./parse_duration_above_zero");
var _is_valid_frequency = require("./is_valid_frequency");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Only allow frequencies in the form of 1s/1h etc.
const frequencyValidator = arg => {
  const parsedArg = (0, _parse_duration_above_zero.parseDurationAboveZero)(arg);
  if (Array.isArray(parsedArg)) {
    return parsedArg;
  }
  return (0, _is_valid_frequency.isValidFrequency)(parsedArg) ? [] : [_messages.frequencyNotValidErrorMessage];
};
exports.frequencyValidator = frequencyValidator;