"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithCopyToClipboard = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../hover_actions/actions/translations");
var _tooltip_with_keyboard_shortcut = require("../tooltip_with_keyboard_shortcut");
var _clipboard = require("./clipboard");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/timelines/public/components/clipboard/with_copy_to_clipboard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Renders `children` with an adjacent icon that when clicked, copies `text` to
 * the clipboard and displays a confirmation toast
 */
const WithCopyToClipboard = exports.WithCopyToClipboard = /*#__PURE__*/_react.default.memo(({
  isHoverAction,
  keyboardShortcut = '',
  showTooltip = true,
  text,
  titleSummary
}) => {
  return showTooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_tooltip_with_keyboard_shortcut.TooltipWithKeyboardShortcut, {
      additionalScreenReaderOnlyContext: text,
      content: _translations.COPY_TO_CLIPBOARD,
      shortcut: keyboardShortcut,
      showShortcut: keyboardShortcut !== '',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_clipboard.Clipboard, {
    content: text,
    isHoverAction: isHoverAction,
    titleSummary: titleSummary,
    toastLifeTimeMs: 800,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_clipboard.Clipboard, {
    content: text,
    isHoverAction: isHoverAction,
    titleSummary: titleSummary,
    toastLifeTimeMs: 800,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  });
});
WithCopyToClipboard.displayName = 'WithCopyToClipboard';