"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineRequestBasicOptionsSchema = void 0;
var _zod = require("@kbn/zod");
var _filter_query = require("../model/filter_query");
var _runtime_mappings = require("../model/runtime_mappings");
var _timerange = require("../model/timerange");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timelineRequestBasicOptionsSchema = exports.timelineRequestBasicOptionsSchema = _zod.z.object({
  indexType: _zod.z.string().optional(),
  id: _zod.z.string().optional(),
  timerange: _timerange.timerange.optional(),
  filterQuery: _filter_query.filterQuery,
  defaultIndex: _zod.z.array(_zod.z.string()).optional(),
  entityType: _zod.z.enum(['events', 'sessions']).optional(),
  runtimeMappings: _runtime_mappings.runtimeMappings,
  params: _zod.z.any().optional(),
  filterStatus: _zod.z.union([_zod.z.literal('open'), _zod.z.literal('closed'), _zod.z.literal('acknowledged')]).optional()
});