"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TelemetryManagementSection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _public = require("@kbn/usage-collection-plugin/public");
var _managementSettingsFieldDefinition = require("@kbn/management-settings-field-definition");
var _managementSettingsComponentsFieldRow = require("@kbn/management-settings-components-field-row");
var _opt_in_example_flyout = require("./opt_in_example_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/telemetry_management_section/public/components/telemetry_management_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LazyFieldRow = /*#__PURE__*/_react.default.lazy(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/management-settings-components-field-row')))).FieldRow
}));
const FieldRow = (0, _sharedUxUtility.withSuspense)(LazyFieldRow);
class TelemetryManagementSection extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "maybeGetAppliesSettingMessage", () => {
      if (!this.props.showAppliesSettingMessage) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "primary",
        iconType: "spacesApp",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "telemetry.callout.appliesSettingTitle",
          defaultMessage: "Changes to this setting apply to {allOfKibanaText} and are saved automatically.",
          values: {
            allOfKibanaText: /*#__PURE__*/_react.default.createElement("strong", {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 160,
                columnNumber: 17
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "telemetry.callout.appliesSettingTitle.allOfKibanaText",
              defaultMessage: "all of Kibana",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 161,
                columnNumber: 19
              }
            }))
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 155,
            columnNumber: 11
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 7
        }
      });
    });
    (0, _defineProperty2.default)(this, "renderDescription", () => {
      const {
        docLinks
      } = this.props;
      const clusterDataLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: this.toggleExample,
        "data-test-id": "cluster_data_example",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 178,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.clusterData",
        defaultMessage: "cluster data",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 9
        }
      }));
      const securityDataLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/security/current/advanced-settings.html#telemetry-settings",
        "data-test-id": "endpoint_security_example",
        target: "_blank",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.securityData",
        defaultMessage: "security data",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 9
        }
      }));
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 194,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.telemetryConfigAndLinkDescription",
        defaultMessage: "Enabling usage collection allows us to learn what our users are most interested in, so we can improve our products and services. Refer to our {privacyStatementLink}.",
        values: {
          privacyStatementLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks.legal.privacyStatement,
            target: "_blank",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 203,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "telemetry.readOurUsageDataPrivacyStatementLinkText",
            defaultMessage: "Privacy Statement",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 204,
              columnNumber: 19
            }
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 196,
          columnNumber: 11
        }
      })), /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.seeExampleOfClusterDataAndEndpointSecuity",
        defaultMessage: "See examples of the {clusterData} and {securityData} that we collect.",
        values: {
          clusterData: clusterDataLink,
          securityData: securityDataLink
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 214,
          columnNumber: 11
        }
      })));
    });
    (0, _defineProperty2.default)(this, "toggleOptIn", async () => {
      const {
        telemetryService,
        toasts
      } = this.props;
      const newOptInValue = !this.state.enabled;
      return new Promise((resolve, reject) => {
        this.setState({
          processing: true,
          enabled: newOptInValue
        }, async () => {
          try {
            await telemetryService.setOptIn(newOptInValue);
            this.setState({
              processing: false
            });
            toasts.addSuccess(newOptInValue ? _i18n.i18n.translate('telemetry.optInSuccessOn', {
              defaultMessage: 'Sharing usage with Elastic is enabled.'
            }) : _i18n.i18n.translate('telemetry.optInSuccessOff', {
              defaultMessage: 'No longer sharing usage with Elastic.'
            }));
            resolve(true);
          } catch (err) {
            this.setState({
              processing: false
            });
            reject(err);
          }
        });
      });
    });
    (0, _defineProperty2.default)(this, "toggleExample", () => {
      this.setState({
        showExample: !this.state.showExample
      });
    });
    this.state = {
      processing: false,
      showExample: false,
      showSecurityExample: false,
      enabled: this.props.telemetryService.getIsOptedIn() || false
    };
  }
  render() {
    const {
      telemetryService
    } = this.props;
    const {
      showExample,
      enabled,
      processing
    } = this.state;
    if (!telemetryService.getCanChangeOptInStatus()) {
      return null;
    }
    const usageCollectionSetting = {
      type: 'boolean',
      value: true,
      userValue: enabled,
      name: _i18n.i18n.translate('telemetry.provideUsageDataTitle', {
        defaultMessage: 'Share usage with Elastic'
      }),
      // @ts-expect-error
      description: this.renderDescription(),
      requiresPageReload: false
    };

    // We don't validate the user input on these settings
    const settingsValidationResponse = {
      successfulValidation: true,
      valid: true
    };
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 7
      }
    }, showExample && /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
      viewId: "optInExampleFlyout",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 39
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_opt_in_example_flyout.OptInExampleFlyout, {
      fetchExample: telemetryService.fetchExample,
      onClose: this.toggleExample,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
      hasBorder: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "telemetry.usageDataTitle",
      defaultMessage: "Usage collection",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 19
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 13
      }
    }, this.maybeGetAppliesSettingMessage(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRowProvider, {
      links: this.props.docLinks.management,
      showDanger: message => this.props.toasts.addDanger(message),
      validateChange: async () => settingsValidationResponse,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(FieldRow, {
      field: (0, _managementSettingsFieldDefinition.getFieldDefinition)({
        id: 'Usage collection',
        setting: usageCollectionSetting,
        params: {
          isOverridden: false,
          isCustom: true
        }
      }),
      isSavingEnabled: this.props.enableSaving && !processing,
      onFieldChange: this.toggleOptIn,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 17
      }
    }))))));
  }
}

// required for lazy loading
// eslint-disable-next-line import/no-default-export
exports.TelemetryManagementSection = TelemetryManagementSection;
var _default = exports.default = TelemetryManagementSection;