"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createOverviewTrendsRoute = void 0;
exports.fetchTrends = fetchTrends;
exports.getIntervalForCheckCount = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../common/constants");
var _fetch_trends = require("./fetch_trends");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIntervalForCheckCount = (schedule, numChecks = 50) => Number(schedule) * numChecks;
exports.getIntervalForCheckCount = getIntervalForCheckCount;
async function fetchTrends(esClient, configs) {
  const requests = Object.keys(configs).map(key => (0, _fetch_trends.getFetchTrendsQuery)(key, configs[key].locations, configs[key].interval));
  const results = await esClient.msearch(requests);
  return results.responses.reduce((table, res) => {
    var _res$aggregations;
    (_res$aggregations = res.aggregations) === null || _res$aggregations === void 0 ? void 0 : _res$aggregations.byId.buckets.map(({
      key,
      byLocation
    }) => {
      const nTable = {};
      for (const location of byLocation.buckets) {
        nTable[String(key) + String(location.key)] = {
          configId: String(key),
          locationId: String(location.key),
          data: location.last50.buckets.map((durationBucket, x) => ({
            x,
            y: durationBucket.max.value
          })),
          ...location.stats,
          median: location.median.values['50.0']
        };
      }
      table = {
        ...table,
        ...nTable
      };
    });
    return table;
  }, {});
}
const createOverviewTrendsRoute = () => ({
  method: 'POST',
  writeAccess: false,
  path: _constants.SYNTHETICS_API_URLS.OVERVIEW_TRENDS,
  validate: {
    body: _configSchema.schema.arrayOf(_configSchema.schema.object({
      configId: _configSchema.schema.string(),
      locationId: _configSchema.schema.string(),
      schedule: _configSchema.schema.string()
    }))
  },
  handler: async routeContext => {
    const esClient = routeContext.syntheticsEsClient;
    const body = routeContext.request.body;
    const configs = body.reduce((acc, {
      configId,
      locationId,
      schedule
    }) => {
      if (!acc[configId]) {
        acc[configId] = {
          locations: [locationId],
          interval: getIntervalForCheckCount(schedule)
        };
      } else {
        acc[configId].locations.push(locationId);
      }
      return acc;
    }, {});
    return fetchTrends(esClient, configs);
  }
});
exports.createOverviewTrendsRoute = createOverviewTrendsRoute;