"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetCurrentStatusRoute = void 0;
var _overview_status_service = require("./overview_status_service");
var _constants = require("../../../common/constants");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGetCurrentStatusRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.OVERVIEW_STATUS,
  validate: {
    query: _common.OverviewStatusSchema
  },
  handler: async routeContext => {
    const statusOverview = new _overview_status_service.OverviewStatusService(routeContext);
    return await statusOverview.getOverviewStatus();
  }
});
exports.createGetCurrentStatusRoute = createGetCurrentStatusRoute;