"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tlsTranslations = exports.commonStateTranslations = exports.commonMonitorStateI18 = exports.STATUS_RULE_NAME = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATUS_RULE_NAME = exports.STATUS_RULE_NAME = _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus', {
  defaultMessage: 'Synthetics monitor status'
});
const commonMonitorStateI18 = exports.commonMonitorStateI18 = [{
  name: 'monitorName',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.monitor', {
    defaultMessage: 'Name of the monitor.'
  })
}, {
  name: 'monitorId',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.monitorId', {
    defaultMessage: 'ID of the monitor.'
  })
}, {
  name: 'monitorUrl',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.monitorUrl', {
    defaultMessage: 'URL of the monitor.'
  })
}, {
  name: 'monitorType',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.monitorType', {
    defaultMessage: 'Type (e.g. HTTP/TCP) of the monitor.'
  })
}, {
  name: 'monitorTags',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.monitorTags', {
    defaultMessage: 'Tags associated with the monitor.'
  })
}, {
  name: 'status',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.status', {
    defaultMessage: 'Monitor status (e.g "down").'
  })
}, {
  name: 'lastErrorMessage',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.lastErrorMessage', {
    defaultMessage: 'Monitor last error message.'
  })
}, {
  name: 'lastErrorStack',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.lastErrorStack', {
    defaultMessage: 'Monitor last error stack trace.'
  })
}, {
  name: 'locationName',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.locationName', {
    defaultMessage: 'Location name from which the check is performed.'
  })
}, {
  name: 'locationNames',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.locationNames', {
    defaultMessage: 'Location names from which the checks are performed.'
  })
}, {
  name: 'locationId',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.locationId', {
    defaultMessage: 'Location id from which the check is performed.'
  })
}, {
  name: 'hostName',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.observerHostname', {
    defaultMessage: 'Hostname of the location from which the check is performed.'
  })
}, {
  name: 'checkedAt',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.checkedAt', {
    defaultMessage: 'Timestamp of the monitor run.'
  })
}, {
  name: 'serviceName',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.serviceName', {
    defaultMessage: 'Service name associated with the monitor.'
  })
}, {
  name: 'labels',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.labels', {
    defaultMessage: 'Labels associated with the monitor.'
  })
}];
const commonStateTranslations = exports.commonStateTranslations = [{
  name: 'firstCheckedAt',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.firstCheckedAt', {
    defaultMessage: 'Timestamp indicating when the alert was first checked.'
  })
}, {
  name: 'firstTriggeredAt',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.firstTriggeredAt', {
    defaultMessage: 'Timestamp indicating when the alert first triggered.'
  })
}, {
  name: 'isTriggered',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.isTriggered', {
    defaultMessage: `Flag indicating if the alert is currently triggering.`
  })
}, {
  name: 'lastCheckedAt',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.lastCheckedAt', {
    defaultMessage: `Timestamp indicating the alert most recent check time.`
  })
}, {
  name: 'lastResolvedAt',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.lastResolvedAt', {
    defaultMessage: `Timestamp indicating the most recent resolution time for this alert.`
  })
}, {
  name: 'lastTriggeredAt',
  description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.state.lastTriggeredAt', {
    defaultMessage: `Timestamp indicating the alert most recent trigger time.`
  })
}];
const tlsTranslations = exports.tlsTranslations = {
  validAfterExpiredString: (date, relativeDate) => _i18n.i18n.translate('xpack.synthetics.rules.tls.validAfterExpiredString', {
    defaultMessage: `Expired on {date}, {relativeDate} days ago.`,
    values: {
      date,
      relativeDate
    }
  }),
  validAfterExpiringString: (date, relativeDate) => _i18n.i18n.translate('xpack.synthetics.rules.tls.validAfterExpiringString', {
    defaultMessage: `Expires on {date} in {relativeDate} days.`,
    values: {
      date,
      relativeDate
    }
  }),
  validBeforeExpiredString: (date, relativeDate) => _i18n.i18n.translate('xpack.synthetics.rules.tls.validBeforeExpiredString', {
    defaultMessage: 'Valid since {date}, {relativeDate} days ago.',
    values: {
      date,
      relativeDate
    }
  }),
  validBeforeExpiringString: (date, relativeDate) => _i18n.i18n.translate('xpack.synthetics.rules.tls.validBeforeExpiringString', {
    defaultMessage: 'Invalid until {date}, {relativeDate} days from now.',
    values: {
      date,
      relativeDate
    }
  }),
  expiredLabel: _i18n.i18n.translate('xpack.synthetics.rules.tls.expiredLabel', {
    defaultMessage: 'has expired'
  }),
  expiringLabel: _i18n.i18n.translate('xpack.synthetics.rules.tls.expiringLabel', {
    defaultMessage: 'is expiring soon'
  }),
  agingLabel: _i18n.i18n.translate('xpack.synthetics.rules.tls.agingLabel', {
    defaultMessage: 'is becoming too old'
  }),
  invalidLabel: _i18n.i18n.translate('xpack.synthetics.rules.tls.invalidLabel', {
    defaultMessage: 'is invalid'
  })
};