"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorsSortedByStatus = useMonitorsSortedByStatus;
var _react = require("react");
var _reactRedux = require("react-redux");
var _moment = _interopRequireDefault(require("moment"));
var _overview_status = require("../state/overview_status");
var _overview = require("../state/overview");
var _use_url_params = require("./use_url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMonitorsSortedByStatus() {
  const {
    statusFilter
  } = (0, _use_url_params.useGetUrlParams)();
  const {
    status,
    disabledConfigs
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const {
    pageState: {
      sortOrder,
      sortField
    }
  } = (0, _reactRedux.useSelector)(_overview.selectOverviewState);
  return (0, _react.useMemo)(() => {
    if (!status) {
      return [];
    }
    let result = [];
    const {
      downConfigs,
      pendingConfigs,
      upConfigs
    } = status;
    if (statusFilter) {
      switch (statusFilter) {
        case 'down':
          result = Object.values(downConfigs);
          break;
        case 'up':
          result = Object.values(upConfigs);
          break;
        case 'disabled':
          result = Object.values(disabledConfigs !== null && disabledConfigs !== void 0 ? disabledConfigs : {});
          break;
        case 'pending':
          result = Object.values(pendingConfigs);
          break;
        default:
          break;
      }
    } else {
      const upAndDownMonitors = sortOrder === 'asc' ? [...Object.values(downConfigs), ...Object.values(upConfigs)] : [...Object.values(upConfigs), ...Object.values(downConfigs)];
      result = [...upAndDownMonitors, ...Object.values(disabledConfigs !== null && disabledConfigs !== void 0 ? disabledConfigs : {}), ...Object.values(pendingConfigs)];
    }
    switch (sortField) {
      case 'name.keyword':
        result = result.sort((a, b) => a.name.localeCompare(b.name));
        return sortOrder === 'asc' ? result : result.reverse();
      case 'status':
        return result;
      case 'updated_at':
        result = result.sort((a, b) => {
          return (0, _moment.default)(a.updated_at).diff((0, _moment.default)(b.updated_at));
        });
        return sortOrder === 'asc' ? result : result.reverse();
    }
    return result;
  }, [disabledConfigs, sortField, sortOrder, status, statusFilter]);
}