"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepMetaInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _status_badge = require("../../common/monitor_test_result/status_badge");
var _test_time_formats = require("../../../utils/monitor_test_result/test_time_formats");
var _error_details_link = require("../../common/links/error_details_link");
var _step_details_link = require("../../common/links/step_details_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_run_details/components/step_info.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StepMetaInfo = ({
  step,
  stepIndex,
  stateId
}) => {
  var _step$synthetics$step, _step$synthetics$step2, _step$synthetics$step3, _step$synthetics$step4;
  const {
    checkGroupId,
    monitorId
  } = (0, _reactRouterDom.useParams)();
  if (!step) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 4,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }));
  }
  const isFailed = ((_step$synthetics$step = step.synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.status) === 'failed';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, STEP_NAME)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, step === null || step === void 0 ? void 0 : (_step$synthetics$step2 = step.synthetics.step) === null || _step$synthetics$step2 === void 0 ? void 0 : _step$synthetics$step2.name), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    wrap: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
    status: (0, _status_badge.parseBadgeStatus)(step === null || step === void 0 ? void 0 : (_step$synthetics$step3 = step.synthetics.step) === null || _step$synthetics$step3 === void 0 ? void 0 : _step$synthetics$step3.status),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, AFTER_LABEL, (0, _test_time_formats.formatTestDuration)(step === null || step === void 0 ? void 0 : (_step$synthetics$step4 = step.synthetics.step) === null || _step$synthetics$step4 === void 0 ? void 0 : _step$synthetics$step4.duration.us))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, isFailed && stateId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_error_details_link.ErrorDetailsButton, {
    configId: monitorId,
    stateId: stateId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_step_details_link.StepDetailsLinkIcon, {
    asButton: true,
    checkGroup: checkGroupId !== null && checkGroupId !== void 0 ? checkGroupId : step.monitor.check_group,
    configId: monitorId,
    stepIndex: stepIndex,
    label: VIEW_PERFORMANCE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }))));
};
exports.StepMetaInfo = StepMetaInfo;
const STEP_NAME = _i18n.i18n.translate('xpack.synthetics.testDetails.stepName', {
  defaultMessage: 'Step name'
});
const AFTER_LABEL = _i18n.i18n.translate('xpack.synthetics.testDetails.after', {
  defaultMessage: 'After '
});
const VIEW_PERFORMANCE = _i18n.i18n.translate('xpack.synthetics.monitor.step.viewPerformanceBreakdown', {
  defaultMessage: 'View performance breakdown'
});