"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _waterfall_context = require("./context/waterfall_context");
var _waterfall_search = require("./waterfall_header/waterfall_search");
var _waterfall_mime_legend = require("./waterfall_header/waterfall_mime_legend");
var _waterfall_timing_legend = require("./waterfall_header/waterfall_timing_legend");
var _waterfall_tick_axis = require("./waterfall_header/waterfall_tick_axis");
var _styles = require("./styles");
var _constants = require("./constants");
var _sidebar = require("./sidebar");
var _use_bar_charts = require("./use_bar_charts");
var _waterfall_bar_chart = require("./waterfall_bar_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_waterfall_chart/waterfall/waterfall_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const WaterfallChart = ({
  tickFormat,
  domain,
  barStyleAccessor,
  renderSidebarItem,
  renderFlyout
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data,
    query,
    setQuery,
    sidebarItems,
    activeFilters,
    setActiveFilters,
    showOnlyHighlightedNetworkRequests,
    setOnlyHighlighted,
    showCustomMarks,
    setShowCustomMarks,
    totalNetworkRequests,
    highlightedNetworkRequests,
    fetchedNetworkRequests
  } = (0, _waterfall_context.useWaterfallContext)();
  const shouldRenderSidebar = !!(sidebarItems && renderSidebarItem);
  const chartsToDisplay = (0, _use_bar_charts.useBarCharts)({
    data
  });
  const cancelPagePadding = {
    marginLeft: `-${euiTheme.size.l}`,
    marginRight: `-${euiTheme.size.l}`
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'relative',
      ...cancelPagePadding
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartStickyHeaderContainer, {
    "data-test-sub": "syntheticsWaterfallChartStickyHeaderContainer",
    style: {
      background: euiTheme.colors.body
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      height: '100%'
    },
    gutterSize: "s",
    alignItems: "stretch",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, shouldRenderSidebar && /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarWrapper, {
    grow: _constants.SIDEBAR_GROW_SIZE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_waterfall_search.WaterfallSearch, {
    query: query,
    setQuery: setQuery,
    totalNetworkRequests: totalNetworkRequests,
    highlightedNetworkRequests: highlightedNetworkRequests,
    fetchedNetworkRequests: fetchedNetworkRequests,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: shouldRenderSidebar ? _constants.MAIN_GROW_SIZE : true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_waterfall_mime_legend.WaterfallMimeLegend, {
    activeFilters: activeFilters,
    setActiveFilters: setActiveFilters,
    showCustomMarks: showCustomMarks,
    setShowCustomMarks: setShowCustomMarks,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_waterfall_tick_axis.WaterfallTickAxis, {
    showOnlyHighlightedNetworkRequests: showOnlyHighlightedNetworkRequests,
    setOnlyHighlighted: setOnlyHighlighted,
    highlightedNetworkRequests: highlightedNetworkRequests,
    fetchedNetworkRequests: fetchedNetworkRequests,
    shouldRenderSidebar: shouldRenderSidebar,
    domain: domain,
    tickFormat: tickFormat,
    barStyleAccessor: barStyleAccessor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartOuterContainer, {
    "data-test-subj": "syntheticsWaterfallChartOuterContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, shouldRenderSidebar ? /*#__PURE__*/_react.default.createElement(_sidebar.Sidebar, {
    items: sidebarItems,
    render: renderSidebarItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      marginLeft: '-16px'
    },
    grow: shouldRenderSidebar ? _constants.MAIN_GROW_SIZE : true,
    "data-test-subj": "dataOnlyWrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, chartsToDisplay.map((chartData, ind) => /*#__PURE__*/_react.default.createElement(_waterfall_bar_chart.WaterfallBarChart, {
    index: ind,
    key: ind,
    chartData: chartData,
    domain: domain,
    barStyleAccessor: barStyleAccessor,
    tickFormat: tickFormat,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartStickyFooterContainer, {
    "data-test-sub": "syntheticsWaterfallChartStickyFooterContainer",
    style: {
      background: euiTheme.colors.body
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_waterfall_timing_legend.WaterfallTimingLegend, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  })), renderFlyout && renderFlyout());
};
exports.WaterfallChart = WaterfallChart;