"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChunks = exports.MiddleTruncatedText = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _waterfall_tooltip_content = require("./waterfall_tooltip_content");
var _styles = require("./styles");
var _constants = require("./constants");
var _data_formatting = require("../../common/network_data/data_formatting");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_waterfall_chart/waterfall/middle_truncated_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OuterContainer = _common.euiStyled.span`
  position: relative;
  display: inline-flex;
  align-items: center;
  .euiToolTipAnchor {
    min-width: 0;
  }
`; // NOTE: min-width: 0 ensures flexbox and no-wrap children can co-exist

const InnerContainer = _common.euiStyled.span`
  overflow: hidden;
  display: flex;
  align-items: center;
`;
const IndexNumber = (0, _common.euiStyled)(_eui.EuiText)`
  font-family: ${props => props.theme.eui.euiCodeFontFamily};
  margin-right: ${props => props.theme.eui.euiSizeS};
  line-height: ${_constants.FIXED_AXIS_HEIGHT}px;
  text-align: right;
  background-color: ${props => props.theme.eui.euiColorLightestShade};
  text-align: center;
  color: ${props => props.theme.eui.euiColorDarkShade};
`;
const FirstChunk = _common.euiStyled.span`
  text-overflow: ellipsis;
  white-space: nowrap;
  overflow: hidden;
  line-height: ${_constants.FIXED_AXIS_HEIGHT}px;
  font-size: ${_constants.RESOURCE_TITLE_FONT_SIZE}px;
  text-align: left;
`; // safari doesn't auto align text left in some cases

const LastChunk = _common.euiStyled.span`
  flex-shrink: 0;
  line-height: ${_constants.FIXED_AXIS_HEIGHT}px;
  font-size: ${_constants.RESOURCE_TITLE_FONT_SIZE}px;
  text-align: left;
`; // safari doesn't auto align text left in some cases

const StyledButton = (0, _common.euiStyled)(_eui.EuiButtonEmpty)`
  &&& {
    border: none;

    .euiButtonContent {
      display: inline-block;
      padding: 0;
    }
  }
`;
const SecureIcon = (0, _common.euiStyled)(_eui.EuiIcon)`
  margin-right: ${props => props.theme.eui.euiSizeXS};
`;
const getChunks = (text = '') => {
  const END_CHARS = 12;
  const chars = text.split('');
  const splitPoint = chars.length - END_CHARS > 0 ? chars.length - END_CHARS : null;
  const endChars = splitPoint ? chars.splice(splitPoint) : [];
  return {
    first: chars.join(''),
    last: endChars.join('')
  };
};

// Helper component for adding middle text truncation, e.g.
// really-really-really-long....Compressed.js
// Can be used to accommodate content in sidebar item rendering.
exports.getChunks = getChunks;
const MiddleTruncatedText = ({
  index,
  ariaLabel,
  onClick,
  setButtonRef,
  url,
  highestIndex
}) => {
  const secureHttps = url.startsWith('https://');
  const text = url.replace(/https:\/\/www.|http:\/\/www.|http:\/\/|https:\/\//, '');
  const chunks = (0, _react.useMemo)(() => {
    return getChunks(text);
  }, [text]);
  return /*#__PURE__*/_react.default.createElement(OuterContainer, {
    "aria-label": ariaLabel,
    "data-test-subj": "middleTruncatedTextContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "middleTruncatedTextSROnly",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, url)), /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartTooltip, {
    as: _eui.EuiToolTip,
    content: /*#__PURE__*/_react.default.createElement(_waterfall_tooltip_content.WaterfallTooltipContent, {
      text: (0, _data_formatting.formatTooltipHeading)(index, url),
      url,
      index: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }),
    "data-test-subj": "middleTruncatedTextToolTip",
    position: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, onClick ? /*#__PURE__*/_react.default.createElement(StyledButton, {
    onClick: onClick,
    "data-test-subj": `middleTruncatedTextButton${index}`,
    buttonRef: setButtonRef,
    flush: 'left',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(InnerContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(IndexNumber, {
    css: {
      minWidth: `${String(highestIndex).length + 3}ch`
    },
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 17
    }
  }, index), secureHttps && /*#__PURE__*/_react.default.createElement(SecureIcon, {
    type: "lock",
    size: "s",
    color: "success",
    "aria-label": _i18n.i18n.translate('xpack.synthetics.waterfallChart.sidebar.url.https', {
      defaultMessage: 'https'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(FirstChunk, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 17
    }
  }, chunks.first), /*#__PURE__*/_react.default.createElement(LastChunk, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 17
    }
  }, chunks.last))) : /*#__PURE__*/_react.default.createElement(InnerContainer, {
    "aria-hidden": true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(FirstChunk, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  }, index, ". ", chunks.first), /*#__PURE__*/_react.default.createElement(LastChunk, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  }, chunks.last)))), /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsMiddleTruncatedTextLink",
    href: url,
    external: true,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.waterfall.resource.externalLink",
    defaultMessage: "Open resource in new tab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  }))))));
};
exports.MiddleTruncatedText = MiddleTruncatedText;