"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProjectAPIKeys = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _public3 = require("@kbn/security-plugin/public");
var _reactHookForm = require("react-hook-form");
var _help_commands = require("./help_commands");
var _monitor_detail_flyout = require("../../monitors_page/overview/overview/monitor_detail_flyout");
var _api = require("../../../state/monitor_management/api");
var _hooks = require("../../../hooks");
var _spaces_select = require("../components/spaces_select");
var _use_form_wrapped = require("../../../../../hooks/use_form_wrapped");
var _api_key_btn = require("./api_key_btn");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/project_api_keys/project_api_keys.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const syntheticsTestRunDocsLink = 'https://www.elastic.co/guide/en/observability/current/synthetic-run-tests.html';
const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const ProjectAPIKeys = () => {
  var _kServices$fleet, _useKibana$services$a, _useKibana$services, _useKibana$services$a2, _kServices$notificati2, _useKibana$services2, _useKibana$services2$;
  const {
    loading: enablementLoading,
    canManageApiKeys
  } = (0, _hooks.useEnablement)();
  const [apiKey, setApiKey] = (0, _react.useState)(undefined);
  const [loadAPIKey, setLoadAPIKey] = (0, _react.useState)(false);
  const [accessToElasticManagedLocations, setAccessToElasticManagedLocations] = (0, _react.useState)(true);
  const form = (0, _use_form_wrapped.useFormWrapped)({
    mode: 'onSubmit',
    reValidateMode: 'onChange',
    shouldFocusError: true,
    defaultValues: {
      spaces: [_public3.ALL_SPACES_ID]
    }
  });
  const {
    handleSubmit
  } = form;
  const {
    spaces: spacesApi
  } = (0, _public.useKibana)().services;
  const spaces = (0, _react.useMemo)(() => {
    var _form$getValues;
    return (_form$getValues = form.getValues()) === null || _form$getValues === void 0 ? void 0 : _form$getValues.spaces;
  }, [form]);
  const ContextWrapper = (0, _react.useMemo)(() => spacesApi ? spacesApi.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spacesApi]);
  const kServices = (0, _public.useKibana)().services;
  const canSaveIntegrations = !!(kServices !== null && kServices !== void 0 && (_kServices$fleet = kServices.fleet) !== null && _kServices$fleet !== void 0 && _kServices$fleet.authz.integrations.writeIntegrationPolicies);
  const canUsePublicLocations = (_useKibana$services$a = (_useKibana$services = (0, _public.useKibana)().services) === null || _useKibana$services === void 0 ? void 0 : (_useKibana$services$a2 = _useKibana$services.application) === null || _useKibana$services$a2 === void 0 ? void 0 : _useKibana$services$a2.capabilities.uptime.elasticManagedLocationsEnabled) !== null && _useKibana$services$a !== void 0 ? _useKibana$services$a : true;
  const {
    data,
    loading,
    error
  } = (0, _public2.useFetcher)(async () => {
    if (loadAPIKey) {
      return (0, _api.fetchProjectAPIKey)(accessToElasticManagedLocations && Boolean(canUsePublicLocations), spaces);
    }
    return null;
    // FIXME: Dario thinks there is a better way to do this but
    // he's getting tired and maybe the Synthetics folks can fix it
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [loadAPIKey, canUsePublicLocations, spaces]);
  const onSubmit = formData => {
    var _formData$spaces;
    if ((_formData$spaces = formData.spaces) !== null && _formData$spaces !== void 0 && _formData$spaces.length) {
      setLoadAPIKey(true);
    }
  };
  (0, _react.useEffect)(() => {
    if (data !== null && data !== void 0 && data.apiKey) {
      setApiKey(data === null || data === void 0 ? void 0 : data.apiKey.encoded);
    }
    setLoadAPIKey(false);
  }, [data]);
  (0, _react.useEffect)(() => {
    if (error) {
      var _kServices$notificati, _requestError$body;
      const requestError = error;
      kServices === null || kServices === void 0 ? void 0 : (_kServices$notificati = kServices.notifications) === null || _kServices$notificati === void 0 ? void 0 : _kServices$notificati.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.synthetics.createApiKey.error', {
          defaultMessage: 'Error'
        }),
        toastMessage: requestError === null || requestError === void 0 ? void 0 : (_requestError$body = requestError.body) === null || _requestError$body === void 0 ? void 0 : _requestError$body.message
      });
    }
  }, [error, kServices === null || kServices === void 0 ? void 0 : (_kServices$notificati2 = kServices.notifications) === null || _kServices$notificati2 === void 0 ? void 0 : _kServices$notificati2.toasts]);
  const canSave = !!((_useKibana$services2 = (0, _public.useKibana)().services) !== null && _useKibana$services2 !== void 0 && (_useKibana$services2$ = _useKibana$services2.application) !== null && _useKibana$services2$ !== void 0 && _useKibana$services2$.capabilities.uptime.save);
  if (enablementLoading) {
    return /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(ContextWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, form, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    style: {
      maxWidth: '50%'
    },
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 18
      }
    }, GET_API_KEY_GENERATE),
    body: canSave && canManageApiKeys ? /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      component: "form",
      noValidate: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 17
      }
    }, GET_API_KEY_LABEL_DESCRIPTION, ' ', !canSaveIntegrations ? `${API_KEY_DISCLAIMER} ` : '', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsProjectAPIKeysLink",
      href: syntheticsTestRunDocsLink,
      external: true,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 19
      }
    }, LEARN_MORE_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.synthetics.features.elasticManagedLocations', {
        defaultMessage: 'Elastic managed locations enabled'
      }),
      checked: accessToElasticManagedLocations && Boolean(canUsePublicLocations),
      onChange: () => {
        setAccessToElasticManagedLocations(!accessToElasticManagedLocations);
      },
      disabled: !canUsePublicLocations,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_spaces_select.SpaceSelector, {
      helpText: API_KEY_HELP_TEXT,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 17
      }
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 17
      }
    }, GET_API_KEY_REDUCED_PERMISSIONS_LABEL, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsProjectAPIKeysLink",
      href: syntheticsTestRunDocsLink,
      external: true,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 19
      }
    }, LEARN_MORE_LABEL))),
    actions: /*#__PURE__*/_react.default.createElement(_api_key_btn.ApiKeyBtn, {
      loading: loading,
      onClick: handleSubmit(onSubmit),
      apiKey: apiKey,
      isDisabled: !canSave || !canManageApiKeys,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }), apiKey && /*#__PURE__*/_react.default.createElement(_help_commands.HelpCommands, {
    apiKey: apiKey,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 20
    }
  })));
};
exports.ProjectAPIKeys = ProjectAPIKeys;
const LEARN_MORE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.learnMore.label', {
  defaultMessage: 'Learn more'
});
const GET_API_KEY_GENERATE = _i18n.i18n.translate('xpack.synthetics.monitorManagement.getProjectAPIKeyLabel.generate', {
  defaultMessage: 'Generate Project API Key'
});
const GET_API_KEY_LABEL_DESCRIPTION = _i18n.i18n.translate('xpack.synthetics.monitorManagement.getAPIKeyLabel.description', {
  defaultMessage: 'Use an API key to push monitors remotely from a CLI or CD pipeline.'
});
const API_KEY_DISCLAIMER = _i18n.i18n.translate('xpack.synthetics.monitorManagement.getAPIKeyLabel.disclaimer', {
  defaultMessage: 'Please note: In order to use push monitors using private testing locations, you must generate this API key with a user who has Fleet and Integrations write permissions.'
});
const GET_API_KEY_REDUCED_PERMISSIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.getAPIKeyReducedPermissions.description', {
  defaultMessage: 'Use an API key to push monitors remotely from a CLI or CD pipeline. To generate an API key, you must have permissions to manage API keys and Uptime write access. Please contact your administrator.'
});
const API_KEY_HELP_TEXT = _i18n.i18n.translate('xpack.synthetics.privateLocation.apiKeySpacesHelpText', {
  defaultMessage: 'Select the spaces where this API key will be available.'
});